<?php
// include("pl/app-config/DB_config.php");
ini_set('display_errors', '1');
ini_set('display_startup_errors', '1');
error_reporting(E_ALL);
$myName = new Name();

if (isset($_POST['validate'])) {
    $emailing = $_SESSION['account_number'] ?? '';
    $ordination_status_name = "";
//$radius = 100;
    $address = $_POST['location_address'];
    $radius = $_POST['radius'];
    $family = $_POST['family'];
     $_SESSION['family'] = $_POST['family'];;
    $now = intval($_POST['now']); // Ensure $now is an integer

    $coordinates = getCoordinates($address, $googleapi);

    if ($coordinates) {
        $lati = $coordinates['latitude'];
        $longi = $coordinates['longitude'];
    } else {
        die("Unable to fetch coordinates for the provided address.");
    }

    // Prepare query
    if (isset($_GET['worker'])) {
        $status = base64_decode(strtr($_GET['worker'], '-_,', '+/='));
        $rooms_query = "SELECT * FROM `jc_members` WHERE `id` = ? ORDER BY `id` DESC";
        $stmt = $conn->prepare($rooms_query);
        $stmt->bind_param("i", $status);
    } else {
   $rooms_query = "
    SELECT 
        w.*, 
        p.radius, 
        p.distance_unit * DEGREES(
            ACOS(LEAST(1.0, 
                COS(RADIANS(p.latpoint)) * COS(RADIANS(w.lati)) *
                COS(RADIANS(p.longpoint - w.longi)) +
                SIN(RADIANS(p.latpoint)) * SIN(RADIANS(w.lati))
            ))
        ) AS distance
    FROM jc_members AS w
    JOIN (
        SELECT ? AS latpoint, ? AS longpoint, ? AS radius, 111.045 AS distance_unit
    ) AS p ON 1=1
    WHERE w.status = '1' AND  w.`update_family` = '0'
      AND w.lati BETWEEN p.latpoint - (p.radius / p.distance_unit)
                   AND p.latpoint + (p.radius / p.distance_unit)
      AND w.longi BETWEEN p.longpoint - (p.radius / (p.distance_unit * COS(RADIANS(p.latpoint))))
                     AND p.longpoint + (p.radius / (p.distance_unit * COS(RADIANS(p.latpoint))))
    HAVING distance <= radius
    ORDER BY distance
    LIMIT ?";

        $stmt = $conn->prepare($rooms_query);
        $stmt->bind_param("dddi", $lati, $longi, $radius, $now);
    }

    // Execute query
    $stmt->execute();
    $rooms_result = $stmt->get_result();

    if ($rooms_result->num_rows > 0) {
        while ($room = $rooms_result->fetch_assoc()) {
            // Fetch and display worker details
            $ordination_status_name = getOrdinationStatus($room['ordination_status']);
            $statusCSS = $room['status'] == 1 ? "badge bg-grd-success" : "badge bg-grd-danger";
            $statusParam = $room['status'] == 1 ? "Active" : "Not Active";
            $id_enc = strtr(base64_encode($room['id']), '+/=', '-_,');

           // $department_name = $myName->showName($conn, "SELECT `department_name` FROM `department` WHERE `id` = '{$room['department']}'");
            $family_group_name = $myName->showName($conn, "SELECT `name` FROM `family_group` WHERE `id` = '{$room['family']}'");
            $house_fellowship_area = $myName->showName($conn, "SELECT `name` FROM `house_fellowship` WHERE `id` = '{$room['house_fellowship_area']}'");

            echo generateWorkerTable($room, $ordination_status_name, $statusCSS, $statusParam);
        }
    } else {
        echo "No workers found within the specified range.";
    }
}

/**
 * Fetch ordination status name
 */
function getOrdinationStatus($status) {
    $status_names = [
        1 => "Pastor",
        2 => "Assistant Pastor",
        3 => "Deacon",
        4 => "Deaconess",
        5 => "Unordained Minister",
        6 => "Brother",
        7 => "Sister",
    ];
    return $status_names[$status] ?? "Not Specified";
}

/**
 * Fetch coordinates from Google API
 */
function getCoordinates($address, $apiKey) {
    $address = urlencode($address);
    $url = "https://maps.googleapis.com/maps/api/geocode/json?address={$address}&key={$apiKey}";

    $response = file_get_contents($url);
    $response = json_decode($response, true);

    if ($response['status'] == 'OK') {
        $latitude = $response['results'][0]['geometry']['location']['lat'];
        $longitude = $response['results'][0]['geometry']['location']['lng'];
        return ['latitude' => $latitude, 'longitude' => $longitude];
    } else {
        return null;
    }
}


/**
 * Generate HTML table for worker
 */
function generateWorkerTable($worker, $ordination_status_name, $statusCSS, $statusParam) {
     $distance = number_format(floatval($worker['distance']),2);
     $id = $worker['id'];
    return "
     
<tr><td><div class='form-check form-switch form-check-success'>
 <input class='form-check-input' type='checkbox' role='switch' id='flexSwitchCheckSuccess' checked='' name='workers_id[]' value = '{$id}'>
								
							  </div></td>   <td><img src='{$worker['photo']}' width='50px' height='50px'></td> 
         <td>{$worker['surname']}</td> 
         <td>{$worker['first_name']}</td> 
        <td>{$worker['gender']}</td> 
       
         <td>{$worker['address']}</td> 
        <td>{$distance} km</td> 
         </tr>
    ";
}
?>
