<?php 
/*ini_set('display_errors', '1');
ini_set('display_startup_errors', '1');
error_reporting(E_ALL);*/
require_once("../jc/app-config/DB_config.php");

if (!isset($_SESSION['worker_id'])) {
    header("Location: index");
    //exit();
}

if (isset($_POST['change'])) {
    // Validate form inputs
    $password = trim($_POST['password']);
    $password2 = trim($_POST['retype_password']);

    // Check if both passwords match
    if ($password !== $password2) {
        echo '<div class="alert alert-danger" role="alert">Passwords do not match. Please try again.</div>';
       // exit();
    }

    // Check if the password is strong enough (optional but recommended)
    if (strlen($password) < 8) {
        echo '<div class="alert alert-danger" role="alert">Password must be at least 8 characters long.</div>';
        // exit();
    }

    // Prepare statement to get user info
    $user = $_SESSION['worker_id'];
    $stmt = $conn->prepare("SELECT * FROM `jc_members` WHERE `worker_id` = ? AND `status` = 1");
    $stmt->bind_param("s", $user);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows == 1) {
        $customer = $result->fetch_assoc();

        $salt = $customer['salt'];
        $encrypted_password = $customer['encrypted_password'];
        $name = $customer['first_name'];
        $irrelivant = $customer['irrelivant']; // Rename this field to something meaningful in the database

        // Check if password is the same as the current one (default pin check)
        if ($password === $irrelivant) {
            echo '<div class="alert alert-danger" role="alert">Please change your default password!</div>';
            //exit();
        }

        // Encrypt the new password
        $new_salt = substr(sha1(rand()), 0, 10);
        $encrypted_new_password = base64_encode(sha1($password . $new_salt, true) . $new_salt);

        // Update password in the database
        $uuid = uniqid('', true);
        $stmt_update = $conn->prepare("UPDATE `jc_members` SET `password_update` = 1, `unique_id` = ?, `encrypted_password` = ?, `salt` = ?, `irrelivant` = ? WHERE `worker_id` = ?");
        $stmt_update->bind_param("sssss", $uuid, $encrypted_new_password, $new_salt, $password, $user);
        $update_result = $stmt_update->execute();

        if ($update_result) {
            echo '<div class="alert alert-success" role="alert">Password changed successfully. Please wait.</div>';

            // Send email notification (email content simplified)
            $email_subject = "Password Changed for $name";
            $email_message = "
                <html>
                    <body>
                        <p>Your password has been changed successfully.</p>
                    </body>
                </html>";
            $headers = "MIME-Version: 1.0\r\n";
            $headers .= "Content-Type: text/html; charset=UTF-8\r\n";
            $headers .= "From: $inst_email1\r\n";

            // Uncomment to send the email
            /* if (mail($customer['email'], $email_subject, $email_message, $headers)) {
                echo '<div class="alert alert-success" role="alert">A notification email has been sent to $user.</div>';
            } else {
                echo '<div class="alert alert-danger" role="alert">Failed to send the notification email. Please contact the administrator.</div>';
            } */

            header("Refresh: 2; url=index");
           // exit();
        } else {
            echo '<div class="alert alert-danger" role="alert">Failed to update password. Please try again later.</div>';
        }
    } else {
        echo '<div class="alert alert-danger" role="alert">User with email $user not found. Please contact the administrator.</div>';
    }

    $stmt->close();
}

$conn->close();
?>
