<?php
include("../jc/app-config/DB_config.php");

date_default_timezone_set('Africa/Lagos');
$datetime = date("Y-m-d G:i:s");

// Get the current date and calculate start and end of the week
$startOfWeek = date("Y-m-d", strtotime('monday this week'));
$endOfWeek = date("Y-m-d", strtotime('sunday this week'));

// Prepare SQL query to select records where the birthday is within this week
$sql = "SELECT `surname`, `first_name`, `phone_number`, `photo`, `birthdate` 
        FROM `jc_members`
        WHERE 
        `birthdate` != '0000-00-00' AND
        DATE(CONCAT(YEAR(CURDATE()), '-', DATE_FORMAT(`birthdate`, '%m-%d'))) 
        BETWEEN ? AND ? 
        ORDER BY DATE_FORMAT(`birthdate`, '%m-%d')";

// Prepare statement
$stmt = $conn->prepare($sql);
$stmt->bind_param("ss", $startOfWeek, $endOfWeek);

// Execute the statement
$stmt->execute();
$result = $stmt->get_result();

// Check if any results were retrieved
if ($result->num_rows > 0) {
    // Fetch and display the results
    while ($row = $result->fetch_assoc()) {
        $birthdate = date("jS F", strtotime($row['birthdate']));

        // Check if a photo is set for the user
        $photo = isset($row['photo']) ? "../jc/" . $row['photo'] : "../jc/default_photo.jpg";

        $fullname = $row['surname'] . " " . $row['first_name'];

        echo '<div class="card catagory-card">
                <a href="#">
                  <img src="' . $photo . '" style="width: 100%; height: 200px; object-fit: cover;" alt="' . $row['surname'] . '">
                  <h6>*' . $fullname . '*</h6>
                  <h6>*' . $fullname . '*<br>
Date: -' . $birthdate . '-</h6>
                </a>
              </div>';
    }
} else {
    // Display a message if no birthdays are found this week
    echo '<div class="no-results">
            <p>No birthdays found for this week.</p>
          </div>';
}

// Close connection
$stmt->close();
$conn->close();
?>
