<?php
include("../jc/app-config/DB_config.php");
include("../jc/admin-includes/SendingSMS.php");

/*ini_set('display_errors', '1');
ini_set('display_startup_errors', '1');
error_reporting(E_ALL);*/

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['validate'])) {
    // Retrieve form data and sanitize inputs
    $name = mysqli_real_escape_string($conn, $_POST['name']);
    $department_id = mysqli_real_escape_string($conn, $_POST['department']);
    $month = mysqli_real_escape_string($conn, $_POST['month']);
    $members = mysqli_real_escape_string($conn, $_POST['members']);
    $comment = mysqli_real_escape_string($conn, $_POST['comment']);
    $worker_id = $_SESSION['worker_id'] ?? null; // Ensure worker_id is set

    // Get department name securely
    $query = $conn->prepare("SELECT department_name FROM department WHERE id = ?");
    $query->bind_param("i", $department_id);
    $query->execute();
    $result = $query->get_result();
    $department_name = ($row = $result->fetch_assoc()) ? $row['department_name'] : '';

    // Process achievements
    $achievements = '';
    if (!empty($_POST['achievement']) && is_array($_POST['achievement'])) {
        $achievements = implode(', ', array_map(fn($achievement) => mysqli_real_escape_string($conn, $achievement), $_POST['achievement']));
    }

    // Process assets
    $assets = '';
    if (!empty($_POST['asset']) && is_array($_POST['asset'])) {
        $assets = implode(', ', array_map(fn($asset) => mysqli_real_escape_string($conn, $asset), $_POST['asset']));
    }

    // Insert into database securely
    $insert_query = $conn->prepare(
        "INSERT INTO handover_note (name, department_id, department_name, month, achievements, assets, worker_id, members, comment) 
         VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)"
    );
    $insert_query->bind_param("sisssssss", $name, $department_id, $department_name, $month, $achievements, $assets, $worker_id, $members, $comment);

    if ($insert_query->execute()) {
        // Success message
        $phone_number = "07062293359";
        $message = "Handover Note for $department_name from $name submitted successfully.";
        
        sendSms2($phone_number, $message);
        sendSMS($phone_number, "JC", $message);

        echo '<div class="btn btn-success d-block mb-2 alert-dismissible fade show">
                <div class="d-flex align-items-center">
                    <div class="ms-3">
                        <h6 class="mb-0 text-white">Success: Information submitted successfully!</h6>
                    </div>
                </div>
              </div>';
    } else {
        // Error message
        echo '<div class="alert alert-danger alert-dismissible fade show" role="alert">
                <div class="d-flex align-items-center">
                    <div class="ms-3">
                        <h6 class="mb-0 text-white">Failed: Error submitting form: ' . htmlspecialchars($insert_query->error) . '</h6>
                    </div>
                </div>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
              </div>';
    }

    // Close statement
    $insert_query->close();
}

// Function to send SMS using external service
function sendSms2($to, $body) {
    $url = "https://www.bulksmsnigeria.com/api/v1/sms/create";
    $api_token = "Qao0XX14kGRYWN62Ar4NnQFepPMofHC5OFObsMsGYCA8ZDOuDn7hzaCmWGFT";
    $from = "JESUSCASTLE";

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query([
        'api_token' => $api_token,
        'from' => $from,
        'to' => $to,
        'body' => $body
    ]));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    $response = curl_exec($ch);
    if ($response === false) {
        echo "Failed to send SMS: " . curl_error($ch);
    }

    curl_close($ch);
    return $response;
}

// Function to send SMS using SMS API
function sendSMS($phone_number, $sender, $message) {
    global $conn;
    $apikey = (new Name)->showName($conn, "SELECT `apikey` FROM `smsapi` WHERE `status` = '1'");
    $email = (new Name)->showName($conn, "SELECT `email` FROM `smsapi` WHERE `status` = '1'");
    $Sending = new SendingSMS();
    $Sending->smsAPI($phone_number, $sender, $message, $apikey, $email);
}

// Function to send email (placeholder function)
function sendemail_address($conn, $fullname, $email_address, $message) {
    $host = (new Name)->showName($conn, "SELECT `name` FROM `emailapi` WHERE `status` = '1'");
    $port = (new Name)->showName($conn, "SELECT `port` FROM `emailapi` WHERE `status` = '1'");
    $password = (new Name)->showName($conn, "SELECT `password` FROM `emailapi` WHERE `status` = '1'");
    $from_email_address = (new Name)->showName($conn, "SELECT `email` FROM `emailapi` WHERE `status` = '1'");
    sendPaymentEmail($host, $from_email_address, $password, $port, $from_email_address, $GLOBALS['inst_name1'], $fullname, $email_address, $message, "Welcome to " . $GLOBALS['inst_name1']);
}
?>
