<?php
include("app-config/DB_config.php");
$myName = new Name();

$emailing = isset($_SESSION['email']) ? $_SESSION['email'] : '';

$date = $_GET['date'];
$service_type = $_GET['service_type'];

function getDetails($conn, $date, $service_type) {
    $query = "SELECT `id`, `latitude`, `longitude`, `timestamp`, `created_date`, `login_time`, `logout_time`, `registered_by`, `service_id`
    FROM `attendance_log`
    WHERE DATE(`created_date`) = ? AND `service_id` = ?
    ORDER BY `id` ASC";

    $stmt = $conn->prepare($query);
    $stmt->bind_param('ss', $date, $service_type); // Bind parameters to avoid SQL injection
    $stmt->execute();
    $result = $stmt->get_result();
    return $result;
}

// Fetch attendance log data
$pouchiSetups = getDetails($conn, $date, $service_type);
$count = $pouchiSetups->num_rows;

if ($count > 0) {
    while ($row = $pouchiSetups->fetch_assoc()) {
        // Check if variables are not null before passing to htmlspecialchars
        $id = htmlspecialchars($row['id'] ?? '', ENT_QUOTES, 'UTF-8');
        $latitude = htmlspecialchars($row['latitude'] ?? '', ENT_QUOTES, 'UTF-8');
        $longitude = htmlspecialchars($row['longitude'] ?? '', ENT_QUOTES, 'UTF-8');
        $timestamp = htmlspecialchars($row['timestamp'] ?? '', ENT_QUOTES, 'UTF-8');
        $created_date = htmlspecialchars($row['created_date'] ?? '', ENT_QUOTES, 'UTF-8');
        $login_time = htmlspecialchars($row['login_time'] ?? '', ENT_QUOTES, 'UTF-8');
        $logout_time = htmlspecialchars($row['logout_time'] ?? '', ENT_QUOTES, 'UTF-8');
        $registered_by = htmlspecialchars($row['registered_by'] ?? '', ENT_QUOTES, 'UTF-8');
        $service_id = htmlspecialchars($row['service_id'] ?? '', ENT_QUOTES, 'UTF-8');

        $meeting_name = htmlspecialchars($myName->showName($conn, "SELECT `meeting_name` FROM `workers_meeting` WHERE `id` = '$service_id'") ?? '', ENT_QUOTES, 'UTF-8');
        $day_of_week = htmlspecialchars($myName->showName($conn, "SELECT `day_of_week` FROM `workers_meeting` WHERE `id` = '$service_id'") ?? '', ENT_QUOTES, 'UTF-8');
        $start_time = htmlspecialchars($myName->showName($conn, "SELECT `start_time` FROM `workers_meeting` WHERE `id` = '$service_id'") ?? '', ENT_QUOTES, 'UTF-8');
        $end_time = htmlspecialchars($myName->showName($conn, "SELECT `end_time` FROM `workers_meeting` WHERE `id` = '$service_id'") ?? '', ENT_QUOTES, 'UTF-8');
        $first_name = htmlspecialchars($myName->showName($conn, "SELECT `first_name` FROM `js_workers` WHERE `worker_id` = '$registered_by'") ?? '', ENT_QUOTES, 'UTF-8');
        $surname = htmlspecialchars($myName->showName($conn, "SELECT `surname` FROM `js_workers` WHERE `worker_id` = '$registered_by'") ?? '', ENT_QUOTES, 'UTF-8');

        // Fetch coordinates for calculating distance
        $appLat = htmlspecialchars($myName->showName($conn, "SELECT `lati` FROM `js_workers` WHERE `status` = '1'") ?? '', ENT_QUOTES, 'UTF-8');
        $appLong = htmlspecialchars($myName->showName($conn, "SELECT `longi` FROM `js_workers` WHERE `status` = '1'") ?? '', ENT_QUOTES, 'UTF-8');

        // Ensure the latitude and longitude are not null or empty before calculating the distance
        if (!empty($latitude) && !empty($longitude) && !empty($appLat) && !empty($appLong)) {
            $distance = $distance = haversineDistance(floatval($latitude), floatval($longitude), floatval($appLat), floatval($appLong));
        } else {
            $distance = 'N/A';
        }

        // Output table row
        echo '<tr>
            <td><strong>' . $surname . ' ' . $first_name . '</strong></td>
            <td><strong>' . $meeting_name . '</strong></td>
            <td>' . $timestamp . '</td>
            <td>' . $login_time . '</td>
            <td>' . (is_numeric($distance) ? number_format(floatval($distance), 2) . ' km' : $distance) . '</td>
        </tr>';
    }
} else {
    echo '<tr><td colspan="5">No attendance records found.</td></tr>';
}

// Function to calculate distance between two coordinates (Haversine formula)
function haversineDistance($lat1, $lon1, $lat2, $lon2) {
    $earthRadius = 6371; // Earth's radius in kilometers

    // Convert degrees to radians
    $dLat = deg2rad(floatval($lat2) - floatval($lat1));
    $dLon = deg2rad(floatval($lon2) - floatval($lon1));

    // Haversine formula
    $a = sin($dLat / 2) * sin($dLat / 2) +
         cos(deg2rad(floatval($lat1))) * cos(deg2rad(floatval($lat2))) *
         sin($dLon / 2) * sin($dLon / 2);
    $c = 2 * atan2(sqrt($a), sqrt(1 - $a));

    // Calculate distance
    $distance = $earthRadius * $c;
    return $distance;
}

$conn->close();
?>
