<?php
include("../jc/app-config/DB_config.php");
include("../jc/admin-includes/SendingSMS.php");

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['validate'])) {
    // Retrieve form data and sanitize inputs
    $name = mysqli_real_escape_string($conn, $_POST['name']);
    $department_id = mysqli_real_escape_string($conn, $_POST['department']);
    $month = mysqli_real_escape_string($conn, $_POST['month']);
    $comment = mysqli_real_escape_string($conn, $_POST['comment']);
    $worker_id = $_SESSION['worker_id'] ?? null; // Ensure worker_id is set

    // Get selected workers and count them
    $members = 0;
    $workers = [];
    if (isset($_POST['workers']) && is_array($_POST['workers'])) {
        $workers = array_map(function ($worker) use ($conn) {
            return mysqli_real_escape_string($conn, $worker);
        }, $_POST['workers']);
        $members = count($workers);
    }

    // Get department name securely
    $query = $conn->prepare("SELECT department_name FROM department WHERE id = ?");
    $query->bind_param("i", $department_id);
    $query->execute();
    $result = $query->get_result();
    $department_name = ($row = $result->fetch_assoc()) ? $row['department_name'] : '';
    $query->close();

    // Process achievements
    $achievements = '';
    if (!empty($_POST['achievement']) && is_array($_POST['achievement'])) {
        $achievements = implode(', ', array_map(function ($achievement) use ($conn) {
            return mysqli_real_escape_string($conn, $achievement);
        }, $_POST['achievement']));
    }

    // Process assets
    $assets = '';
    if (!empty($_POST['asset']) && is_array($_POST['asset'])) {
        $assets = implode(', ', array_map(function ($asset) use ($conn) {
            return mysqli_real_escape_string($conn, $asset);
        }, $_POST['asset']));
    }

    // Insert handover note into the database
    $insert_query = $conn->prepare(
        "INSERT INTO handover_note (name, department_id, department_name, month, achievements, assets, worker_id, members, comment) 
         VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)"
    );
    $insert_query->bind_param("sisssssss", $name, $department_id, $department_name, $month, $achievements, $assets, $worker_id, $members, $comment);

    if ($insert_query->execute()) {
        // Get the last inserted ID for the handover_note
        $handover_id = $insert_query->insert_id;

        // Insert selected workers into active_workers table
        if (!empty($workers)) {
            $worker_insert_query = $conn->prepare("INSERT INTO active_workers (worker_id, handover_id) VALUES (?, ?)");
            foreach ($workers as $worker) {
                $worker_insert_query->bind_param("ii", $worker, $handover_id);
                $worker_insert_query->execute();
            }
            $worker_insert_query->close();
        }

        // Send success message
        $phone_number = "08028181779";
        $phone_number2 = "08035029259";
        $phone_number3 = "08035538658";
        $message = "Handover Note for $department_name from $name submitted successfully.";

        // Uncomment to send SMS notifications
        // sendSms2($phone_number, $message);
        // sendSMS($phone_number, "JC", $message);
        // sendSms2($phone_number2, $message);
        // sendSMS($phone_number2, "JC", $message);
  sendSms2($phone_number3, $message);
      sendSMS($phone_number3, "JC", $message);

        echo '<div class="btn btn-success d-block mb-2 alert-dismissible fade show">
                <div class="d-flex align-items-center">
                    <div class="ms-3">
                        <h6 class="mb-0 text-white">Success: Information submitted successfully!</h6>
                    </div>
                </div>
              </div>';
    } else {
        // Error message
        echo '<div class="alert alert-danger alert-dismissible fade show" role="alert">
                <div class="d-flex align-items-center">
                    <div class="ms-3">
                        <h6 class="mb-0 text-white">Failed: Error submitting form: ' . htmlspecialchars($insert_query->error) . '</h6>
                    </div>
                </div>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
              </div>';
    }

    // Close statement
    $insert_query->close();
}

// Function to send SMS using external service
function sendSms2($to, $body) {
    $url = "https://www.bulksmsnigeria.com/api/v1/sms/create";
    $api_token = "Qao0XX14kGRYWN62Ar4NQFepPMofHC5OFObsMsGYCA8ZDOuDn7hzaCmWGFT";
    $from = "JESUSCASTLE";

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query([
        'api_token' => $api_token,
        'from' => $from,
        'to' => $to,
        'body' => $body
    ]));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    $response = curl_exec($ch);
    if ($response === false) {
        echo "Failed to send SMS: " . curl_error($ch);
    }

    curl_close($ch);
    return $response;
}

// Function to send SMS using SMS API
function sendSMS($phone_number, $sender, $message) {
    global $conn;
    $apikey = (new Name)->showName($conn, "SELECT `apikey` FROM `smsapi` WHERE `status` = '1'");
    $email = (new Name)->showName($conn, "SELECT `email` FROM `smsapi` WHERE `status` = '1'");
    $Sending = new SendingSMS();
    $Sending->smsAPI($phone_number, $sender, $message, $apikey, $email);
}

// Placeholder function for sending email
function sendemail_address($conn, $fullname, $email_address, $message) {
    $host = (new Name)->showName($conn, "SELECT `name` FROM `emailapi` WHERE `status` = '1'");
    $port = (new Name)->showName($conn, "SELECT `port` FROM `emailapi` WHERE `status` = '1'");
    $password = (new Name)->showName($conn, "SELECT `password` FROM `emailapi` WHERE `status` = '1'");
    $from_email_address = (new Name)->showName($conn, "SELECT `email` FROM `emailapi` WHERE `status` = '1'");
    sendPaymentEmail($host, $from_email_address, $password, $port, $from_email_address, $GLOBALS['inst_name1'], $fullname, $email_address, $message, "Welcome to " . $GLOBALS['inst_name1']);
}
?>
