<?php 
session_start();
error_reporting(E_ALL);
ini_set('display_errors', true);
include("../jc/app-config/DB_config.php"); 

// Function to calculate distance between two coordinates (Haversine formula)
function haversineDistance($lat1, $lon1, $lat2, $lon2) {
    $earthRadius = 6371; // Earth's radius in km

    $dLat = deg2rad($lat2 - $lat1);
    $dLon = deg2rad($lon2 - $lon1);

    $a = sin($dLat / 2) * sin($dLat / 2) +
         cos(deg2rad($lat1)) * cos(deg2rad($lat2)) *
         sin($dLon / 2) * sin($dLon / 2);
    $c = 2 * atan2(sqrt($a), sqrt(1 - $a));

    return $earthRadius * $c; // Distance in km
}

// Check if attendance has already been submitted for the day
$today = date("Y-m-d");
$hasSubmitted = isset($_SESSION['has_submitted']) && $_SESSION['has_submitted'] == $today;

if ($hasSubmitted) {
    echo "Attendance for today has already been submitted.";
    exit;
}

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['userLat']) && isset($_POST['userLong'])) {
    
    // Get the user's location from POST
    $userLat = $_POST['userLat'];
    $userLong = $_POST['userLong'];
 
     // Get current time and day of the week
        $currentDateTime = new DateTime();
        $dayOfWeek = $currentDateTime->format('l'); // Day name, e.g., "Monday"
        $timeNow = $currentDateTime->format('H:i');

    
    
    // Query the database for meeting information
    $sql = "SELECT meeting_name, day_of_week, start_time, end_time FROM workers_meeting WHERE status = 1 AND day_of_week = '$dayOfWeek'"; // Modify if needed to get the correct meeting
    $result = $conn->query($sql);

    if ($result->num_rows > 0) {
        $meeting = $result->fetch_assoc();
        $meeting_name = $meeting['meeting_name'];

       
        
        echo "here 3 / ".$dayOfWeek." / ".$meeting['day_of_week'] ."<p>";
    echo "   ".$timeNow." / ".$meeting['start_time']  ."<p>";
    echo "   ".$timeNow." / ".$meeting['end_time']  ."<p>";
        // Compare with the meeting details
        
        
        // Compare with the meeting details
           if ($dayOfWeek == $meeting['day_of_week'] && $timeNow >= $meeting['start_time'] && $timeNow <= $meeting['end_time']) {
            
            // Query the database for the application location
            $locationSql = "SELECT lati, longi FROM application WHERE status = 1";
            $locationResult = $conn->query($locationSql);

            $isWithinRadius = false;

            if ($locationResult->num_rows > 0) {
                // Loop through the results and check the distance
                while ($row = $locationResult->fetch_assoc()) {
                    $appLat = $row['lati'];
                    $appLong = $row['longi'];

                    // Check if the user is within a 2km radius
                    if (haversineDistance($userLat, $userLong, $appLat, $appLong) <= 300) { // 2 km radius
                        $isWithinRadius = true;
                        break;
                    }
                }
            }

            // If user is within the radius, show the button to sign in
            if ($isWithinRadius) {
                echo "<button name='validate'>Sign in for $meeting_name at $timeNow</button>";
            } else {
                echo "You are not within the required 2km radius.";
            }
        } else {
            echo "Button is only available during the meeting hours: " . $meeting['start_time'] . " to " . $meeting['end_time'] . " on " . $meeting['day_of_week'];
        }
    } else {
        echo "No meeting found with status = 1.";
    }

    exit;
}

if (isset($_POST['validate'])) {
    $userLat = $_POST['userLat'];
    $userLong = $_POST['userLong'];
    $timestamp = date("Y-m-d H:i:s");
    $registeredBy = isset($_SESSION['worker_id']) ? $_SESSION['worker_id'] : "";

    // Get current datetime and time
    $datetime = date("Y-m-d H:i:s");
    $time = date("H:i:s");

    // Insert the attendance record into the database
    $sql = "INSERT INTO attendance_log (latitude, longitude, timestamp, registered_by, created_date, login_time) VALUES (?, ?, ?, ?, ?, ?)";
    $stmt = $conn->prepare($sql);

    if ($stmt) {
        $stmt->bind_param("ddssss", $userLat, $userLong, $timestamp, $registeredBy, $datetime, $time);

        if ($stmt->execute()) {
            // Mark that the user has submitted attendance for today
            $_SESSION['has_submitted'] = $today;
            echo "Activation recorded successfully! Attendance for today submitted.";
        } else {
            echo "Error: " . $stmt->error;
        }

        $stmt->close();
    } else {
        echo "Error preparing the statement: " . $conn->error;
    }

    exit;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Activate Button</title>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
</head>
<body>
    <div id="activationButton">
        <!-- The button or message will be injected here -->
        Loading...
    </div>

    <script>
        var userLat, userLong;
        
        // Use the HTML5 Geolocation API to get the user's location
        navigator.geolocation.getCurrentPosition(function(position) {
            userLat = position.coords.latitude;
            userLong = position.coords.longitude;

            // Send the user's location to the server via POST to check activation
            $.post('attendance2.php', {
                userLat: userLat,
                userLong: userLong
            }, function(response) {
                // Display the response (button or message)
                document.getElementById("activationButton").innerHTML = response;

                // Add an event listener to the button after it's added
                $('button').on('click', function() {
                    submitActivation();
                });
            });
        });

        // Function to submit coordinates and timestamp upon button click
        function submitActivation() {
            $.post('attendance2.php', {
                userLat: userLat,
                userLong: userLong,
                validate: true
            }, function(response) {
                alert(response); // Show success or error message

                // If successful, remove the button and display a success message
                if (response.includes("Activation recorded successfully")) {
                    document.getElementById("activationButton").innerHTML = "Attendance submitted for today.";
                }
            });
        }
    </script>
</body>
</html>
