 <?php 
session_start();
ini_set('display_errors', '1');
ini_set('display_startup_errors', '1');
error_reporting(E_ALL);

include("../jc/app-config/DB_config.php"); 
 

// Function to calculate distance between two coordinates (Haversine formula)
function haversineDistance($lat1, $lon1, $lat2, $lon2) {
    $earthRadius = 6371; // Earth's radius in km

    $dLat = deg2rad($lat2 - $lat1);
    $dLon = deg2rad($lon2 - $lon1);

    $a = sin($dLat / 2) * sin($dLat / 2) +
         cos(deg2rad($lat1)) * cos(deg2rad($lat2)) *
         sin($dLon / 2) * sin($dLon / 2);
    $c = 2 * atan2(sqrt($a), sqrt(1 - $a));

    return $earthRadius * $c; // Distance in km
}

// Check if attendance has already aaaabeen submitted for the day
$today = date("Y-m-d");
$hasSubmitted = isset($_SESSION['has_submitted']) && $_SESSION['has_submitted'] == $today;

if ($hasSubmitted) {
   //echo "";
    echo '<div class="btn btn-primary d-block mb-2" role="alert">Attendance for today has already been submitted.</div>';
     exit;
}
 

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['userLat']) && isset($_POST['userLong']) && !isset($_POST['validate'])) {
    
    // Get the user's location from POST
    $userLat = $_POST['userLat'];
    $userLong = $_POST['userLong'];
    $userLong = $_POST['userLong'];
 
    // Get current time and day of the week
    $currentDateTime = new DateTime();
    $dayOfWeek = $currentDateTime->format('l'); // Day name, e.g., "Monday"
    $timeNow = $currentDateTime->format('H:i');

    // Query the database for meeting information
    $sql = "SELECT id, meeting_name, day_of_week, start_time, end_time FROM workers_meeting WHERE status = 1 AND day_of_week = '$dayOfWeek'"; 
    $result = $conn->query($sql);

    if ($result->num_rows > 0) {
        $meeting = $result->fetch_assoc();
        $meeting_name = $meeting['meeting_name'];
        $id = $meeting['id'];
        $_SESSION['service_id'] = $id;
        // Compare with the meeting details
        if ($dayOfWeek == $meeting['day_of_week'] && $timeNow >= $meeting['start_time'] && $timeNow <= $meeting['end_time']) {
            
            // Query the database for the application location
            $locationSql = "SELECT lati, longi FROM application WHERE status = 1";
            $locationResult = $conn->query($locationSql);

            $isWithinRadius = false;

            if ($locationResult->num_rows > 0) {
                // Loop through the results and check the distance
                while ($row = $locationResult->fetch_assoc()) {
                    $appLat = $row['lati'];
                    $appLong = $row['longi'];

                    // Check if the user is within a 300-meter radius
                    if (haversineDistance($userLat, $userLong, $appLat, $appLong) <= 300) { // 300 meters
                        $isWithinRadius = true;
                        break;
                    }
                }
            }

            // If user is within the radius, show the button to sign in
            if ($isWithinRadius) {
               // echo "<button id='validateButton'>Sign in for $meeting_name at $timeNow</button>";
                
                echo '<button   id="validateButton" name = "validate" type="submit" class="box__link button-animation">
    CLICK HERE TO MARK ATTENDANCE
    <span></span>
    <span></span>
    <span></span>
    <span></span>
    <span></span>
  </button>
  <input type="hidden" name="service_id" value = "'.$id.'">
 
  ';
            } else {
              // echo "You are not within the required 300-meter radius.";
                  echo '<div class="btn btn-primary d-block mb-2" role="alert">You are not within the required radius.</div>';
                
            }
        } else {
            echo '<div class="btn btn-primary d-block mb-2" role="alert">Button is only available during the meeting hours: ' . $meeting['start_time'] . ' to ' . $meeting['end_time'] . ' on ' . $meeting['day_of_week'].'</div>';
        }
    } else {
        echo '<div class="btn btn-primary d-block mb-2" role="alert">No meeting found for today.</div>';
    }

    exit;
}
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['validate'])) {
    $userLat = $_POST['userLat'];
    $userLong = $_POST['userLong'];
    $service_id = $_SESSION['service_id'];
    $timestamp = date("Y-m-d H:i:s");
    $registeredBy = isset($_SESSION['worker_id']) ? $_SESSION['worker_id'] : "";

    // Insert the attendance record into the database
    $sql = "INSERT INTO attendance_log (latitude, longitude, timestamp, registered_by, created_date, login_time, service_id) VALUES (?, ?, ?, ?, ?, ?, ?)";
    $stmt = $conn->prepare($sql);

    if ($stmt) {
        $datetime = date("Y-m-d H:i:s");
        $time = date("H:i:s");
        $stmt->bind_param("ddsssss", $userLat, $userLong, $timestamp, $registeredBy, $datetime, $time, $service_id);

        if ($stmt->execute()) {
            // Mark that the user has submitted attendance for today
            $_SESSION['has_submitted'] = $today;
            echo '<div class="btn btn-success d-block mb-2" role="alert">Activation recorded successfully! Attendance for today submitted.</div>';
        } else {
            echo '<div class="btn btn-primary d-block mb-2" role="alert">Error: ' . $stmt->error . '</div>';
        }

        $stmt->close();
    } else {
        echo '<div class="btn btn-primary d-block mb-2" role="alert">Error preparing the statement: ' . $conn->error . '</div>';
    }

    exit;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    
    
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Activate Button</title>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    
   <style>
    /* Google Fonts */
    @import url("https://fonts.googleapis.com/css2?family=Montserrat:wght@400;600&display=swap");

    /* Variables */
    :root {
      --body-color: #393937;
      --accent-color: #03e9f4;
      --white-color: #fff;
      --box-shadow: 0 0 5px #03e9f4, 0 0 25px #03e9f4, 0 0 50px #03e9f4, 0 0 100px #03e9f4;
      --body-font: "Montserrat", sans-serif;
      --normal-font-size: 1rem;
      --font-regular: 400;
      --font-semi-bold: 600;
      --z-tooltip: 10;
      --z-fixed: 100;
    }

    /* Base styles */
    * {
      box-sizing: border-box;
      padding: 0;
      margin: 0;
    }

    body {
      font-family: var(--body-font);
      font-size: var(--normal-font-size);
      background: var(--body-color);
      min-height: 100vh;
      display: flex;
      justify-content: center;
      align-items: center;
      padding: 20px;
    }

    a, button {
      text-decoration: none;
      border: none;
      outline: none;
      background: none;
    }

    /* Button and anchor tag animation */
    .button-animation {
      position: relative;
      display: inline-block;
      width: 120px; /* Increase width */
      height: 120px; /* Increase height */
      line-height: 120px; /* Center text vertically */
 
      color: var(--accent-color);
      text-transform: uppercase;
      overflow: hidden;
      letter-spacing: 2px;
      transition: 0.5s;
      font-size: 1.2rem; /* Slightly increase font size */
      cursor: pointer;
      margin: 10px;
      text-align: center; /* Center text horizontally */
    }

    .button-animation span {
      position: absolute;
      display: block;
    }

    /* Animation for span elements */
    .button-animation span:nth-child(1) {
      top: 0;
      left: -100%;
      width: 100%;
      height: 2px;
      background: linear-gradient(90deg, transparent, var(--accent-color));
      animation: btn-anim1 1s linear infinite;
    }

    @keyframes btn-anim1 {
      0% {
        left: -100%;
      }
      50%, 100% {
        left: 100%;
      }
    }

    .button-animation span:nth-child(2) {
      top: -100%;
      right: 0;
      width: 2px;
      height: 100%;
      background: linear-gradient(180deg, transparent, var(--accent-color));
      animation: btn-anim2 1s linear infinite;
      animation-delay: 0.25s;
    }

    @keyframes btn-anim2 {
      0% {
        top: -100%;
      }
      50%, 100% {
        top: 100%;
      }
    }

    .button-animation span:nth-child(3) {
      bottom: 0;
      right: -100%;
      width: 100%;
      height: 2px;
      background: linear-gradient(270deg, transparent, var(--accent-color));
      animation: btn-anim3 1s linear infinite;
      animation-delay: 0.5s;
    }

    @keyframes btn-anim3 {
      0% {
        right: -100%;
      }
      50%, 100% {
        right: 100%;
      }
    }

    .button-animation span:nth-child(4) {
      bottom: -100%;
      left: 0;
      width: 2px;
      height: 100%;
      background: linear-gradient(360deg, transparent, var(--accent-color));
      animation: btn-anim4 1s linear infinite;
      animation-delay: 0.75s;
    }

    @keyframes btn-anim4 {
      0% {
        bottom: -100%;
      }
      50%, 100% {
        bottom: 100%;
      }
    }

    /* Hover effect to add glow */
    .button-animation:hover {
      background-color: var(--accent-color);
      color: var(--white-color);
      box-shadow: var(--box-shadow);
    }

    /* Responsive styling */
    @media screen and (max-width: 768px) {
      .button-animation {
        width: 100px;
        height: 100px;
        line-height: 100px;
        font-size: 1rem;
      }
    }

    @media screen and (max-width: 480px) {
      .button-animation {
        width: 80px;
        height: 80px;
        line-height: 80px;
        font-size: 0.8rem;
      }
    }

  </style>
</head>
<body>
    <div id="activationButton">
        <!-- The button or message will be injected here -->
        Loading...!
    </div>

    <script>
        var userLat, userLong;

        // Use the HTML5 Geolocation API to get the user's location
        navigator.geolocation.getCurrentPosition(function(position) {
            userLat = position.coords.latitude;
            userLong = position.coords.longitude;
   alert(" ssss1"+);
            // Send the user's location to the server via POST to check activation
            $.post('attendance3.php', {
                userLat: userLat,
                userLong: userLong
            }, function(response) {
                // Display the response (button or message)
                document.getElementById("activationButton").innerHTML = response;

                // Add an event listener to the button after it's added
                $('#validateButton').on('click', function() {
                    submitActivation();
                });
            });
        });

        // Function to submit coordinates and timestamp upon button click
        function submitActivation() {
            //alert("SDASD");
            $.post('attendance3.php', {
                userLat: userLat,
                userLong: userLong,
                validate: true
            }, function(response) {
               // alert(response); // Show success or error message

                // If successful, remove the button and display a success message
                if (response.includes("Activation recorded successfully")) {
                    document.getElementById("activationButton").innerHTML = '<div class="btn btn-primary d-block mb-2" role="alert">Attendance submitted for today.</div>';
                }
            });
        }
    </script>
</body>
</html>
