<?php
include("../jc/app-config/DB_config.php");

if (isset($_GET['id'])) {
    $id = intval($_GET['id']);

    $sql = "SELECT file_path FROM bulletin_uploads WHERE id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $stmt->bind_result($filePath);
    $stmt->fetch();
    $stmt->close();

    if ($filePath) {
        // Extract just the filename
        $fileName = basename($filePath);

        // Local filesystem path
        $localFilePath = $_SERVER['DOCUMENT_ROOT'] . "/jc/bulletin/" . $fileName;

        if (file_exists($localFilePath)) {
            $fileSize = filesize($localFilePath);
            $fileExtension = strtolower(pathinfo($localFilePath, PATHINFO_EXTENSION));
            $contentType = getContentType($fileExtension);

            // Headers
            header("Content-Type: $contentType");
            header("Content-Disposition: attachment; filename=\"$fileName\"");
            header("Content-Length: $fileSize");
            header("Pragma: no-cache");
            header("Expires: 0");

            ob_clean();
            flush();
            readfile($localFilePath);
            exit;
        } else {
            die("File not found on server: " . $localFilePath);
        }
    } else {
        die("No file path found in database.");
    }
} else {
    die("Invalid request.");
}

function getContentType($extension) {
    $types = [
        'pdf' => 'application/pdf',
        'doc' => 'application/msword',
        'docx' => 'application/vnd.openxmlformats-officedocument.wordprocessingml.document',
        'jpg' => 'image/jpeg',
        'jpeg' => 'image/jpeg',
        'png' => 'image/png',
        'gif' => 'image/gif',
        'txt' => 'text/plain',
    ];
    return isset($types[$extension]) ? $types[$extension] : 'application/octet-stream';
}
?>
