<?php

$emailing = "";
include("admin-includes/view-application-external.php");
 
// Handle form submission
if (isset($_POST['validate'])) {

    if (isset($_SESSION['email'])) {
        $emailing = $_SESSION['email'];
    }

    $location_name = sanitize_input($conn, $_POST['location']);
    $status = '1';
    $datetime = date('Y-m-d H:i:s');
    $registeredby = $emailing;

    // Retrieve the data from the form
    $location = $_POST['location'];
    $amenities = $_POST['amenities']; // Array of amenities
    $icons = $_FILES['icon']; // Array of files (icons)
    $desc = $_POST['desc']; // Array of files (icons)

    // Define your custom maximum file size (in bytes)
    $maxFileSize = 2 * 1024 * 1024; // 2MB limit

    // Prepare the SQL statement
    $stmt = $conn->prepare("INSERT INTO location_amenities (`location_id`, `amenities`, `icon`, `status`, `created_at`, `details`) VALUES (?, ?, ?, ?, ?, ?)");

    // Loop through the arrays and insert each pair into the database
    for ($i = 0; $i < count($amenities); $i++) {
        $amenity = sanitize_input($conn, $amenities[$i]); // Sanitize each amenity
        $desc1 = sanitize_input($conn, $desc[$i]); // Sanitize each amenity
        $status = 1; // Assuming status is an integer with a value of 1

        // Handle file upload for the icon
        if (isset($icons['name'][$i]) && $icons['error'][$i] == 0) {
            // Check file size
            if ($icons['size'][$i] > $maxFileSize) {
                $iconPath = null;
                error_log("File too large: " . $icons['name'][$i] . " exceeds the maximum size of " . ($maxFileSize / 1024 / 1024) . "MB.");
                echo '<a href="#" class="btn btn-danger btn-lg">File too large: ' . htmlspecialchars($icons['name'][$i]) . ' exceeds the maximum size of ' . ($maxFileSize / 1024 / 1024) . 'MB.</a><br />';
                continue; // Skip this file and continue with the next iteration
            }

            // Define the target directory
            $targetDir = "uploads/icons/";
            // Create the directory if it doesn't exist
            if (!is_dir($targetDir)) {
                mkdir($targetDir, 0777, true);
            }

            // Generate a unique file name
            $fileName = basename($icons['name'][$i]);
            $targetFilePath = $targetDir . time() . "_" . $fileName;

            // Move the uploaded file to the target directory
            if (move_uploaded_file($icons['tmp_name'][$i], $targetFilePath)) {
                $iconPath = $targetFilePath; // Store the file path in the database
            } else {
                $iconPath = null; // Handle file upload failure
                error_log("Failed to move uploaded file for icon: " . $icons['name'][$i]);
            }
        } else {
            $iconPath = null; // No file uploaded or there was an error
            if ($icons['error'][$i] != 0) {
                error_log("Error uploading file: " . $icons['name'][$i] . " Error code: " . $icons['error'][$i]);
            }
        }

        // Bind parameters
        $stmt->bind_param("isssss", $location, $amenity, $iconPath, $status, $datetime, $desc1);

        // Execute the statement
        $stmt->execute();
    }

    // Check if the statement was successful
    if ($stmt->affected_rows > 0) {
         echo '<div class="alert alert-success border-0 bg-grd-success alert-dismissible fade show">
									<div class="d-flex align-items-center">
										<div class="font-35 text-white"><span class="material-icons-outlined fs-2">check_circle</span>
										</div>
										<div class="ms-3">
											<h6 class="mb-0 text-white">Success</h6>
											<div class="text-white">Information Submitted Successfully</div>
										</div>
									</div>
									<button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
								</div>';
    } else {
        echo '<a href="#" class="btn btn-danger btn-lg">Information Not Submitted Successfully. <br />Please try again later.</a><br />';
    }

    // Close the statement and connection
    $stmt->close();
    $conn->close();
}

// Function to sanitize inputs
function sanitize_input($conn, $data) {
    return mysqli_real_escape_string($conn, trim($data));
}

?>
