<?php

$emailing = "";

if (isset($_POST['validate'])) {
   
    if (isset($_SESSION['email'])) {
        $emailing = $_SESSION['email'];
    }
$lati = '';
$longi = '';
    // Database connection (assumed to be $conn)
    // include your database connection script here
 //   include 'db_connection.php'; // Example

    $name = sanitize_input($conn, $_POST['name']);
    $slogan = sanitize_input($conn, $_POST['slogan']);
    $email = sanitize_input($conn, $_POST['email']);
    $phone = sanitize_input($conn, $_POST['phone']);
    $address = sanitize_input($conn, $_POST['address']);
    $googleapi = sanitize_input($conn, $_POST['googleapi']);
    $radius = sanitize_input($conn, $_POST['radius']);
    $datetime = date('Y-m-d H:i:s'); // Ensure $datetime is defined

     $coordinates = getCoordinates($address, $googleapi);

    if ($coordinates) {
        $lati = $coordinates['latitude'];
        $longi = $coordinates['longitude'];
    }
    
    
    
    $logo = handle_logo_upload($conn);

    if ($logo !== false) {
        if (record_exists($conn)) {
            $result = update_application($conn, $name, $phone, $email, $slogan, $address, $logo, $datetime, $emailing, $googleapi, $lati, $longi, $radius);
        } else {
            $result = insert_application($conn, $name, $phone, $email, $slogan, $address, $logo, $datetime, $emailing, $googleapi, $lati, $longi, $radius);
        }

        if ($result) {
             echo '<div class="alert alert-success border-0 bg-grd-success alert-dismissible fade show">
									<div class="d-flex align-items-center">
										<div class="font-35 text-white"><span class="material-icons-outlined fs-2">check_circle</span>
										</div>
										<div class="ms-3">
											<h6 class="mb-0 text-white">Success</h6>
											<div class="text-white">Information Submitted Successfully</div>
										</div>
									</div>
									<button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
								</div>';
            echo '<meta http-equiv="Refresh" content="1; url=admin-includes/logout.php">';
        } else {
            echo '<a href="#" class="btn btn-danger btn-lg">Information Not Submitted Successfully. <br />Please try again later.</a><br />';
        }
    } else {
        echo '<a href="#" class="btn btn-danger btn-lg">Logo upload failed. <br />Please try again later.</a><br />';
    }

    $conn->close();
}

function sanitize_input($conn, $data) {
    return mysqli_real_escape_string($conn, trim($data));
}

function handle_logo_upload($conn) {
    if (basename($_FILES["logo"]["name"]) == "") {
        return trim(mysqli_real_escape_string($conn, $_POST['logo1']));
    } else {
        $target_dir = "graphicallity/";
        $target_file = $target_dir . basename($_FILES["logo"]["name"]);
        $uploadOk = 1;
        $imageFileType = strtolower(pathinfo($target_file, PATHINFO_EXTENSION));

        // Check if image file is a actual image or fake image
        $check = getimagesize($_FILES["logo"]["tmp_name"]);
        if ($check === false) {
            echo "<div class='btn btn-danger btn-lg'>File is not an image.</div><br />";
            $uploadOk = 0;
        }

        // Check if file already exists
        if (file_exists($target_file)) {
            echo "<div class='btn btn-danger btn-lg'>Sorry, file already exists.</div><br />";
            $uploadOk = 0;
        }

        // Check file size
        if ($_FILES["logo"]["size"] > 500000) {
            echo "<div class='btn btn-danger btn-lg'>Sorry, your file is too large.</div><br />";
            $uploadOk = 0;
        }

        // Allow certain file formats
        if (!in_array($imageFileType, ['jpg', 'jpeg', 'png', 'gif'])) {
            echo "<div class='btn btn-danger btn-lg'>Sorry, only JPG, JPEG, PNG & GIF files are allowed.</div><br />";
            $uploadOk = 0;
        }

        if ($uploadOk === 0) {
            return false;
        } else {
            if (move_uploaded_file($_FILES["logo"]["tmp_name"], $target_file)) {
                echo "<div class='btn btn-success btn-lg'>The file " . basename($_FILES["logo"]["name"]) . " has been uploaded.</div>";
                return $target_file;
            } else {
                echo "<div class='btn btn-danger btn-lg'>Sorry, there was an error uploading your file.</div><br />";
                return false;
            }
        }
    }
}

function record_exists($conn) {
    $query = "SELECT * FROM `application`";
    $result = mysqli_query($conn, $query) or die(mysqli_error($conn));
    return mysqli_num_rows($result) > 0;
}

function update_application($conn, $name, $phone, $email, $slogan, $address, $logo, $datetime, $emailing, $googleapi, $lati, $longi, $radius) {
    $stmt = $conn->prepare("UPDATE `application` SET `name` = ?, `phone` = ?, `email` = ?, `slogan` = ?, `address` = ?, `logo` = ?, `status` = '1', `created_date` = ?, `registeredby` = ?, `googleapi` = ?,`lati` = ?,`longi` = ? ,`radius` = ?   WHERE 1");
    $stmt->bind_param("ssssssssssss", $name, $phone, $email, $slogan, $address, $logo, $datetime, $emailing, $googleapi, $lati, $longi, $radius);
    return $stmt->execute();
}

function insert_application($conn, $name, $phone, $email, $slogan, $address, $logo, $datetime, $emailing, $googleapi, $lati, $longi, $radius) {
    $stmt = $conn->prepare("INSERT INTO `application`(`name`, `phone`, `email`, `slogan`, `address`, `logo`, `status`, `created_date`, `registeredby`, `googleapi`, `lati`, `longi`, `radius`) VALUES (?, ?, ?, ?, ?, ?, '1', ?, ?, ?, ?, ?, ?)");
    $stmt->bind_param("ssssssssssss", $name, $phone, $email, $slogan, $address, $logo, $datetime, $emailing, $googleapi, $lati, $longi, $radius);
    return $stmt->execute();
}

// Function to get coordinates from Google API
function getCoordinates($address, $apiKey) {
    $address = urlencode($address);
    $url = "https://maps.googleapis.com/maps/api/geocode/json?address={$address}&key={$apiKey}";

    $response = file_get_contents($url);
    $response = json_decode($response, true);

    if ($response['status'] == 'OK') {
        $latitude = $response['results'][0]['geometry']['location']['lat'];
        $longitude = $response['results'][0]['geometry']['location']['lng'];
        return ['latitude' => $latitude, 'longitude' => $longitude];
    } else {
        return null;
    }
}
?>
