<?php
require_once("app-config/DB_config.php");
include("admin-includes/view-application-external.php");

if (isset($_POST['validate'])) {

    // Sanitize and collect form data
    $location_name = sanitize_input($conn, $_POST['location_name']);
    $location_address = sanitize_input($conn, $_POST['location_address']);
    $leader = sanitize_input($conn, $_POST['leader']);
    $leader = sanitize_input($conn, $_POST['leader']);
    $zone_id = sanitize_input($conn, $_POST['zone_id']);
    $registered_by = $_SESSION['email'] ?? 'Unknown';

    // Latitude and Longitude handling
    $lati = "";
    $longi = "";
    $coordinates = getCoordinates($location_address, $googleapi);

    if ($coordinates) {
        $lati = $coordinates['latitude'];
        $longi = $coordinates['longitude'];
    }
    else
    {
          echo '<div class="alert alert-danger border-0 bg-grd-danger alert-dismissible fade show">
									<div class="d-flex align-items-center">
										<div class="font-35 text-white"><span class="material-icons-outlined fs-2">report_gmailerrorred</span>
										</div>
										<div class="ms-3">
											<h6 class="mb-0 text-white">Error Occurred: </h6>
											<div class="text-white">Coordinates not captured. Please try again later.</div>
										</div>
									</div>
									<button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
								</div>';
        
    }
    
    $logo = handle_logo_upload($conn);
    // Insert into the `areas` table
   $created_at = date("Y-m-d H:i:s");

// Check if an area with the same name already exists
$check_sql = "SELECT id FROM areas WHERE name = '$location_name'";
$check_result = mysqli_query($conn, $check_sql);

if (mysqli_num_rows($check_result) > 0) {
    // Area name already exists
    echo '<div class="alert alert-warning border-0 bg-grd-warning alert-dismissible fade show">
            <div class="d-flex align-items-center">
                <div class="font-35 text-white"><span class="material-icons-outlined fs-2">error</span>
                </div>
                <div class="ms-3">
                    <h6 class="mb-0 text-white">Warning</h6>
                    <div class="text-white">An area with the same name already exists!</div>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
          </div>';
} else {
    // Proceed with insertion if no duplicate is found
    $sql = "INSERT INTO areas (name, address, longi, lati, pastor, created_at, registeredby, logo, zone_id) 
            VALUES ('$location_name', '$location_address', '$longi', '$lati', '$leader', '$created_at', '$registered_by', '$logo', '$zone_id')";

    if (mysqli_query($conn, $sql)) {
        echo '<div class="alert alert-success border-0 bg-grd-success alert-dismissible fade show">
                <div class="d-flex align-items-center">
                    <div class="font-35 text-white"><span class="material-icons-outlined fs-2">check_circle</span>
                    </div>
                    <div class="ms-3">
                        <h6 class="mb-0 text-white">Success</h6>
                        <div class="text-white">Information Submitted Successfully!!</div>
                    </div>
                </div>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
              </div>';
    } else {
        echo '<div class="alert alert-danger border-0 bg-grd-danger alert-dismissible fade show">
                <div class="d-flex align-items-center">
                    <div class="font-35 text-white"><span class="material-icons-outlined fs-2">report_gmailerrorred</span>
                    </div>
                    <div class="ms-3">
                        <h6 class="mb-0 text-white">Error Occurred: </h6>
                        <div class="text-white">Database query failed: ' . mysqli_error($conn) . '</div>
                    </div>
                </div>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
              </div>';
    }
}

}
else if (isset($_POST['update']))
{
    
    // Sanitize and collect form data
    $location_name = sanitize_input($conn, $_POST['location_name']);
    $location_address = sanitize_input($conn, $_POST['location_address']);
    $leader = sanitize_input($conn, $_POST['leader']);
    $iding = sanitize_input($conn, $_POST['id']);
    $registered_by = $_SESSION['email'] ?? 'Unknown';
  $zone_id = sanitize_input($conn, $_POST['zone_id']);
    // Latitude and Longitude handling
    $lati = "";
    $longi = "";
    $coordinates = getCoordinates($location_address, $googleapi);
  $logo = handle_logo_upload($conn);
    if ($coordinates) {
        $lati = $coordinates['latitude'];
        $longi = $coordinates['longitude'];
    } else
    {
          echo '<div class="alert alert-danger border-0 bg-grd-danger alert-dismissible fade show">
									<div class="d-flex align-items-center">
										<div class="font-35 text-white"><span class="material-icons-outlined fs-2">report_gmailerrorred</span>
										</div>
										<div class="ms-3">
											<h6 class="mb-0 text-white">Error Occurred: </h6>
											<div class="text-white">Coordinates not captured. Please try again later.</div>
										</div>
									</div>
									<button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
								</div>';
        
    }

    // Insert into the `areas` table
    $created_at = date("Y-m-d H:i:s");
    $sql = "UPDATE areas SET zone_id='$zone_id', logo='$logo',  name='$location_name', address='$location_address', longi='$longi', lati='$lati', pastor='$leader',  registeredby='$registered_by' WHERE `id` = '$iding'";

    if (mysqli_query($conn, $sql)) {
      
          echo '<div class="alert alert-success border-0 bg-grd-success alert-dismissible fade show">
									<div class="d-flex align-items-center">
										<div class="font-35 text-white"><span class="material-icons-outlined fs-2">check_circle</span>
										</div>
										<div class="ms-3">
											<h6 class="mb-0 text-white">Success</h6>
											<div class="text-white">Information Updated Successfully!!</div>
										</div>
									</div>
									<button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
								</div>';
        
        
        
    } else {
       // echo '<a href="#" class="btn btn-danger btn-lg">Error: ' . mysqli_error($conn) . '</a><br />';
        
        
            echo '<div class="alert alert-danger border-0 bg-grd-danger alert-dismissible fade show">
									<div class="d-flex align-items-center">
										<div class="font-35 text-white"><span class="material-icons-outlined fs-2">report_gmailerrorred</span>
										</div>
										<div class="ms-3">
											<h6 class="mb-0 text-white">Error Occurred: </h6>
											<div class="text-white">Database query failed:  '. mysqli_error($conn).'</div>
										</div>
									</div>
									<button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
								</div>';
    }
    
}
// Function to sanitize user input
function sanitize_input($conn, $data) {
    return mysqli_real_escape_string($conn, trim($data));
}

// Function to get coordinates from Google API
function getCoordinates($address, $apiKey) {
    $address = urlencode($address);
    $url = "https://maps.googleapis.com/maps/api/geocode/json?address={$address}&key={$apiKey}";

    $response = file_get_contents($url);
    $response = json_decode($response, true);

    if ($response['status'] == 'OK') {
        $latitude = $response['results'][0]['geometry']['location']['lat'];
        $longitude = $response['results'][0]['geometry']['location']['lng'];
        return ['latitude' => $latitude, 'longitude' => $longitude];
    } else {
        return null;
    }
}

 function handle_logo_upload($conn) {
    if (basename($_FILES["logo"]["name"]) == "") {
        return trim(mysqli_real_escape_string($conn, $_POST['logo1']));
    } else {
        $target_dir = "logos/";
        $imageFileType = strtolower(pathinfo($_FILES["logo"]["name"], PATHINFO_EXTENSION));
        
        // Generate a unique filename to avoid conflicts
        $unique_name = uniqid('logo_', true) . '.' . $imageFileType;
        $target_file = $target_dir . $unique_name;
        
        $uploadOk = 1;

        // Check if image file is a actual image or fake image
        $check = getimagesize($_FILES["logo"]["tmp_name"]);
        if ($check === false) {
            echo "<div class='btn btn-danger btn-lg'>File is not an image.</div><br />";
            $uploadOk = 0;
        }

        // Check file size
        if ($_FILES["logo"]["size"] > 500000) {
            echo "<div class='btn btn-danger btn-lg'>Sorry, your file is too large.</div><br />";
            $uploadOk = 0;
        }

        // Allow certain file formats
        if (!in_array($imageFileType, ['jpg', 'jpeg', 'png', 'gif'])) {
            echo "<div class='btn btn-danger btn-lg'>Sorry, only JPG, JPEG, PNG & GIF files are allowed.</div><br />";
            $uploadOk = 0;
        }

        if ($uploadOk === 0) {
            return false;
        } else {
            if (move_uploaded_file($_FILES["logo"]["tmp_name"], $target_file)) {
                echo "<div class='btn btn-success btn-lg'>The file " . htmlspecialchars($unique_name) . " has been uploaded.</div>";
                return $target_file;
            } else {
                echo "<div class='btn btn-danger btn-lg'>Sorry, there was an error uploading your file.</div><br />";
                return false;
            }
        }
    }
}

/*
function handle_logo_upload($conn) {
    if (basename($_FILES["logo"]["name"]) == "") {
        return trim(mysqli_real_escape_string($conn, $_POST['logo1']));
    } else {
        $target_dir = "logos/";
        $target_file = $target_dir . basename($_FILES["logo"]["name"]);
        $uploadOk = 1;
        $imageFileType = strtolower(pathinfo($target_file, PATHINFO_EXTENSION));

        // Check if image file is a actual image or fake image
        $check = getimagesize($_FILES["logo"]["tmp_name"]);
        if ($check === false) {
            echo "<div class='btn btn-danger btn-lg'>File is not an image.</div><br />";
            $uploadOk = 0;
        }

        // Check if file already exists
        if (file_exists($target_file)) {
            echo "<div class='btn btn-danger btn-lg'>Sorry, file already exists.</div><br />";
            $uploadOk = 0;
        }

        // Check file size
        if ($_FILES["logo"]["size"] > 500000) {
            echo "<div class='btn btn-danger btn-lg'>Sorry, your file is too large.</div><br />";
            $uploadOk = 0;
        }

        // Allow certain file formats
        if (!in_array($imageFileType, ['jpg', 'jpeg', 'png', 'gif'])) {
            echo "<div class='btn btn-danger btn-lg'>Sorry, only JPG, JPEG, PNG & GIF files are allowed.</div><br />";
            $uploadOk = 0;
        }

        if ($uploadOk === 0) {
            return false;
        } else {
            if (move_uploaded_file($_FILES["logo"]["tmp_name"], $target_file)) {
                echo "<div class='btn btn-success btn-lg'>The file " . basename($_FILES["logo"]["name"]) . " has been uploaded.</div>";
                return $target_file;
            } else {
                echo "<div class='btn btn-danger btn-lg'>Sorry, there was an error uploading your file.</div><br />";
                return false;
            }
        }
    }
}*/
?>
