<?php
// Include database configuration
include("app-config/DB_config.php");

// Define the target directory
$targetDir = "uploads/banners/";
// Create the directory if it doesn't exist
if (!is_dir($targetDir)) {
    mkdir($targetDir, 0777, true);
}

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Check if the form is submitted
    if (isset($_POST['validate'])) {
        // Loop through the form fields
        $banner_descriptions = $_POST['banner_desciption'];
        $banner_values = $_POST['banner_value'];
        $icons = $_FILES['icon'];

        for ($i = 0; $i < count($banner_descriptions); $i++) {
            // Escape special characters in inputs
            $description = mysqli_real_escape_string($conn, $banner_descriptions[$i]);
            $banner_value = mysqli_real_escape_string($conn, $banner_values[$i]);

            // Handle file upload
            $icon_name = $icons['name'][$i];
            $icon_tmp_name = $icons['tmp_name'][$i];
            $icon_error = $icons['error'][$i];
            $icon_size = $icons['size'][$i];

            if ($icon_error === 0) {
                // Rename the file to a single word with a unique identifier
                $new_name = "image_" . uniqid('', true) . ".jpg"; // Example: image_6123456789.jpg
                $icon_upload_path = $targetDir . $new_name;

                // Move the file to the target directory
                if (move_uploaded_file($icon_tmp_name, $icon_upload_path)) {
                    // Insert the record into the database
                    $query = "INSERT INTO `banner` (`description`, `banner_value`, `icon`) 
                              VALUES ('$description', '$banner_value', '$icon_upload_path')";

                    if (mysqli_query($conn, $query)) {
                         echo '<div class="alert alert-success border-0 bg-grd-success alert-dismissible fade show">
									<div class="d-flex align-items-center">
										<div class="font-35 text-white"><span class="material-icons-outlined fs-2">check_circle</span>
										</div>
										<div class="ms-3">
											<h6 class="mb-0 text-white">Success</h6>
											<div class="text-white">Information Submitted Successfully</div>
										</div>
									</div>
									<button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
								</div>';
                    } else {
                        echo "Error: " . $query . "<br>" . mysqli_error($conn) . "<br>";
                        echo '<a href="#" class="btn btn-danger btn-lg">Error: ' . $query . '<br>' . mysqli_error($conn) . '<br> </a><br />';
                    }
                } else {
                    echo '<a href="#" class="btn btn-danger btn-lg">Error uploading file ' . $icon_name . '.</a><br />';
                }
            } else {
                echo '<a href="#" class="btn btn-danger btn-lg">Error with the file ' . $icon_name . '. Error code: ' . $icon_error . '.</a><br />';
            }
        }
    }
}

// Close the database connection
mysqli_close($conn);
?>
