<?php
// Include database configuration
include("app-config/DB_config.php");

if (isset($_POST['validate'])) {
    $month = mysqli_real_escape_string($conn, $_POST['month']);
    $year  = mysqli_real_escape_string($conn, $_POST['year']);

    if (!empty($_FILES['pictures']['name'])) {
        // Create bulletin folder if not exists
        $uploadDir = "bulletin/";
        if (!is_dir($uploadDir)) {
            mkdir($uploadDir, 0777, true);
        }

        // Get file extension in lowercase
        $fileExt = strtolower(pathinfo($_FILES['pictures']['name'], PATHINFO_EXTENSION));

        // Allowed extensions
        $allowedExt = ['pdf', 'jpg', 'jpeg', 'png'];

        if (in_array($fileExt, $allowedExt)) {
            // Rename file: Year_Month_random.ext
            $randomNumber = rand(1000, 99999);
            $fileName = $year . "_" . $month . "_" . $randomNumber . "." . $fileExt;
            $targetPath = $uploadDir . $fileName;

            if (move_uploaded_file($_FILES['pictures']['tmp_name'], $targetPath)) {
                $sql = "INSERT INTO bulletin_uploads (month, year, file_path) 
                        VALUES ('$month', '$year', '$targetPath')";

                if (mysqli_query($conn, $sql)) {
                    echo "<div class='alert alert-success'> Bulletin uploaded successfully!</div>";
                } else {
                    echo "<div class='alert alert-danger'>Database error: " . mysqli_error($conn) . "</div>";
                }
            } else {
                echo "<div class='alert alert-danger'>Failed to upload file.</div>";
            }
        } else {
            echo "<div class='alert alert-danger'>Only PDF or image files are allowed.</div>";
        }
    } else {
        echo "<div class='alert alert-danger'>Please select a file to upload.</div>";
    }
}
?>
