<?php
 require_once("../pl/app-config/DB_config.php");

ini_set('display_errors', '1');
ini_set('display_startup_errors', '1');
error_reporting(E_ALL);
 if (!isset($_SESSION['account_number'])) {
    header("Location: index");
    exit();
}

if (isset($_POST['change'])) {
    // Validate form inputs
    $password = trim($_POST['password']);
    $password2 = trim($_POST['retype_password']);

    // Check if both passwords match
    if ($password !== $password2) {
        echo "<script>alert('Passwords do not match. Please try again.');</script>";
        exit();
    }

    // Check if the password is strong enough (optional but recommended)
    if (strlen($password) < 8) {
        echo "<script>alert('Password must be at least 8 characters long.');</script>";
        exit();
    }

    // Prepare statement to get user info
    $user = $_SESSION['account_number'];
    $stmt = $conn->prepare("SELECT * FROM `customer` WHERE `account_number` = ? AND `status` = 1");
    $stmt->bind_param("s", $user);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows == 1) {
        $customer = $result->fetch_assoc();

        $salt = $customer['salt'];
        $encrypted_password = $customer['encrypted_password'];
        $name = $customer['name'];
        $irrelivant = $customer['irrelivant']; // Rename this field to something meaningful in the database

        // Check if password is the same as the current one (default pin check)
        if ($password === $irrelivant) {
            echo "<script>alert('Please change your default password!');</script>";
           // exit();
        }

        // Encrypt the new password
        $new_salt = substr(sha1(rand()), 0, 10);
        $encrypted_new_password = base64_encode(sha1($password . $new_salt, true) . $new_salt);

        // Update password in the database
        $uuid = uniqid('', true);
        $stmt_update = $conn->prepare("UPDATE `customer` SET `password_update` = 1, `unique_id` = ?, `encrypted_password` = ?, `salt` = ?, `irrelivant` = ? WHERE `account_number` = ?");
        $stmt_update->bind_param("sssss", $uuid, $encrypted_new_password, $new_salt, $password, $user);
        $update_result = $stmt_update->execute();

        if ($update_result) {
            echo "<script>alert('Password changed successfully. Please wait.');</script>";

            // Send email notification (email content simplified)
            $email_subject = "Password Changed for $name";
            $email_message = "
                <html>
                    <body>
                        <p>Your password has been changed successfully.</p>
                    </body>
                </html>";
            $headers = "MIME-Version: 1.0\r\n";
            $headers .= "Content-Type: text/html; charset=UTF-8\r\n";
            $headers .= "From: $inst_email1\r\n";

           /* if (mail($customer['email'], $email_subject, $email_message, $headers)) {
                echo "<script>alert('A notification email has been sent to $user.');</script>";
            } else {
                echo "<script>alert('Failed to send the notification email. Please contact the administrator.');</script>";
            }
*/
            header("Refresh: 2; url=index");
            exit();
        } else {
            echo "<script>alert('Failed to update password. Please try again later.');</script>";
        }
    } else {
        echo "<script>alert('User with email $user not found. Please contact the administrator.');</script>";
    }

    $stmt->close();
}

$conn->close();
?>
