<?php

$emailing = "";

// Handle form submission
if (isset($_POST['validate'])) {

    if (isset($_SESSION['email'])) {
        $emailing = $_SESSION['email'];
    }

    // Sanitize input
    $publickey = sanitize_input($conn, $_POST['publickey']);
    $secretkey = sanitize_input($conn, $_POST['secretkey']);
    $encryptionkey = sanitize_input($conn, $_POST['encryptionkey']);
    $url = sanitize_input($conn, $_POST['url']);

    $status = '1';
    $datetime = date('Y-m-d H:i:s');
    $registeredby = $emailing;

    if (record_exists($conn, $publickey)) {
        $result = update_flutterwave($conn, $publickey, $secretkey, $encryptionkey, $url, $status, $datetime, $registeredby);
    } else {
        $result = insert_flutterwave($conn, $publickey, $secretkey, $encryptionkey, $url, $status, $datetime, $registeredby);
    }

    if ($result) {
         echo '<div class="alert alert-success border-0 bg-grd-success alert-dismissible fade show">
									<div class="d-flex align-items-center">
										<div class="font-35 text-white"><span class="material-icons-outlined fs-2">check_circle</span>
										</div>
										<div class="ms-3">
											<h6 class="mb-0 text-white">Success</h6>
											<div class="text-white">Information Submitted Successfully</div>
										</div>
									</div>
									<button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
								</div>';
    } else {
        echo '<a href="#" class="btn btn-danger btn-lg">Information Not Submitted Successfully. <br />Please try again later.</a><br />';
    }

    $conn->close();
}

function sanitize_input($conn, $data) {
    return mysqli_real_escape_string($conn, trim($data));
}

function record_exists($conn, $publickey) {
    $query = "SELECT * FROM flutterwave WHERE publickey = ?";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("s", $publickey);
    $stmt->execute();
    $result = $stmt->get_result();
    return $result->num_rows > 0;
}

function update_flutterwave($conn, $publickey, $secretkey, $encryptionkey, $url, $status, $datetime, $registeredby) {
    $stmt = $conn->prepare("UPDATE flutterwave SET secretkey = ?, encryptionkey = ?, url = ?, status = ?, created_date = ?, registeredby = ? WHERE publickey = ?");
    $stmt->bind_param("sssssss", $secretkey, $encryptionkey, $url, $status, $datetime, $registeredby, $publickey);
    return $stmt->execute();
}

function insert_flutterwave($conn, $publickey, $secretkey, $encryptionkey, $url, $status, $datetime, $registeredby) {
    $stmt = $conn->prepare("INSERT INTO flutterwave (publickey, secretkey, encryptionkey, url, status, created_date, registeredby) VALUES (?, ?, ?, ?, ?, ?, ?)");
    $stmt->bind_param("sssssss", $publickey, $secretkey, $encryptionkey, $url, $status, $datetime, $registeredby);
    return $stmt->execute();
}

?>
