<?php
require_once("app-config/DB_config.php");
include("admin-includes/view-application-external.php");

if (isset($_POST['validate'])) {

    // Sanitize and collect form data
    $location_name = sanitize_input($conn, $_POST['location_name']);
    $location_address = sanitize_input($conn, $_POST['location_address']);
    $leader = sanitize_input($conn, $_POST['leader']);
    $registered_by = $_SESSION['email'] ?? 'Unknown';

    // Latitude and Longitude handling
    $lati = "";
    $longi = "";
    $coordinates = getCoordinates($location_address, $googleapi);

    if ($coordinates) {
        $lati = $coordinates['latitude'];
        $longi = $coordinates['longitude'];
    }
  else
    {
          echo '<div class="alert alert-danger border-0 bg-grd-danger alert-dismissible fade show">
									<div class="d-flex align-items-center">
										<div class="font-35 text-white"><span class="material-icons-outlined fs-2">report_gmailerrorred</span>
										</div>
										<div class="ms-3">
											<h6 class="mb-0 text-white">Error Occurred: </h6>
											<div class="text-white">Coordinates not captured. Please try again later.</div>
										</div>
									</div>
									<button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
								</div>';
        
    }
    // Insert into the `house_fellowship` table
    $created_at = date("Y-m-d H:i:s");
    $sql = "INSERT INTO house_fellowship (name, address, longi, lati, leader, created_at, registeredby) 
            VALUES ('$location_name', '$location_address', '$longi', '$lati', '$leader', '$created_at', '$registered_by')";

    if (mysqli_query($conn, $sql)) {
      
          echo '<div class="alert alert-success border-0 bg-grd-success alert-dismissible fade show">
									<div class="d-flex align-items-center">
										<div class="font-35 text-white"><span class="material-icons-outlined fs-2">check_circle</span>
										</div>
										<div class="ms-3">
											<h6 class="mb-0 text-white">Success</h6>
											<div class="text-white">Information Submitted Successfully!!</div>
										</div>
									</div>
									<button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
								</div>';
        
        
        
    } else {
       // echo '<a href="#" class="btn btn-danger btn-lg">Error: ' . mysqli_error($conn) . '</a><br />';
        
        
            echo '<div class="alert alert-danger border-0 bg-grd-danger alert-dismissible fade show">
									<div class="d-flex align-items-center">
										<div class="font-35 text-white"><span class="material-icons-outlined fs-2">report_gmailerrorred</span>
										</div>
										<div class="ms-3">
											<h6 class="mb-0 text-white">Error Occurred: </h6>
											<div class="text-white">Database query failed:  '. mysqli_error($conn).'</div>
										</div>
									</div>
									<button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
								</div>';
    }
}
else if (isset($_POST['update']))
{
    
    // Sanitize and collect form data
    $location_name = sanitize_input($conn, $_POST['location_name']);
    $location_address = sanitize_input($conn, $_POST['location_address']);
    $leader = sanitize_input($conn, $_POST['leader']);
    $iding = sanitize_input($conn, $_POST['id']);
    $registered_by = $_SESSION['email'] ?? 'Unknown';

    // Latitude and Longitude handling
    $lati = "";
    $longi = "";
    $coordinates = getCoordinates($location_address, $googleapi);

    if ($coordinates) {
        $lati = $coordinates['latitude'];
        $longi = $coordinates['longitude'];
    }
  else
    {
          echo '<div class="alert alert-danger border-0 bg-grd-danger alert-dismissible fade show">
									<div class="d-flex align-items-center">
										<div class="font-35 text-white"><span class="material-icons-outlined fs-2">report_gmailerrorred</span>
										</div>
										<div class="ms-3">
											<h6 class="mb-0 text-white">Error Occurred: </h6>
											<div class="text-white">Coordinates not captured. Please try again later.</div>
										</div>
									</div>
									<button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
								</div>';
        
    }
    // Insert into the `house_fellowship` table
    $created_at = date("Y-m-d H:i:s");
    $sql = "UPDATE house_fellowship SET name='$location_name', address='$location_address', longi='$longi', lati='$lati', leader='$leader',  registeredby='$registered_by' WHERE `id` = '$iding'";

    if (mysqli_query($conn, $sql)) {
      
          echo '<div class="alert alert-success border-0 bg-grd-success alert-dismissible fade show">
									<div class="d-flex align-items-center">
										<div class="font-35 text-white"><span class="material-icons-outlined fs-2">check_circle</span>
										</div>
										<div class="ms-3">
											<h6 class="mb-0 text-white">Success</h6>
											<div class="text-white">Information Updated Successfully!!</div>
										</div>
									</div>
									<button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
								</div>';
        
        
        
    } else {
       // echo '<a href="#" class="btn btn-danger btn-lg">Error: ' . mysqli_error($conn) . '</a><br />';
        
        
            echo '<div class="alert alert-danger border-0 bg-grd-danger alert-dismissible fade show">
									<div class="d-flex align-items-center">
										<div class="font-35 text-white"><span class="material-icons-outlined fs-2">report_gmailerrorred</span>
										</div>
										<div class="ms-3">
											<h6 class="mb-0 text-white">Error Occurred: </h6>
											<div class="text-white">Database query failed:  '. mysqli_error($conn).'</div>
										</div>
									</div>
									<button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
								</div>';
    }
    
}
// Function to sanitize user input
function sanitize_input($conn, $data) {
    return mysqli_real_escape_string($conn, trim($data));
}

// Function to get coordinates from Google API
function getCoordinates($address, $apiKey) {
    $address = urlencode($address);
    $url = "https://maps.googleapis.com/maps/api/geocode/json?address={$address}&key={$apiKey}";

    $response = file_get_contents($url);
    $response = json_decode($response, true);

    if ($response['status'] == 'OK') {
        $latitude = $response['results'][0]['geometry']['location']['lat'];
        $longitude = $response['results'][0]['geometry']['location']['lng'];
        return ['latitude' => $latitude, 'longitude' => $longitude];
    } else {
        return null;
    }
}
?>
