<?php
include("../jc/app-config/DB_config.php");

date_default_timezone_set('Africa/Lagos');
$datetime = date("Y-m-d G:i:s");

// Get start and end dates of the current week (Monday - Sunday)
$startOfWeek = date("Y-m-d", strtotime('monday this week'));
$endOfWeek = date("Y-m-d", strtotime('sunday this week'));

// Prepare SQL query to select records where the birthday is within this week
$sql = "SELECT `surname`, `first_name`, `phone_number`, `photo`, `birth_date` 
        FROM `js_workers`
        WHERE 
        `birth_date` != '0000-00-00' AND
        DATE_FORMAT(`birth_date`, '%m-%d') BETWEEN DATE_FORMAT(?, '%m-%d') AND DATE_FORMAT(?, '%m-%d') 
        ORDER BY DATE_FORMAT(`birth_date`, '%m-%d')";

// Prepare statement
$stmt = $conn->prepare($sql);
$stmt->bind_param("ss", $startOfWeek, $endOfWeek);

// Execute the statement
$stmt->execute();
$result = $stmt->get_result();

// Check if any results were retrieved
if ($result->num_rows > 0) {
    // Fetch and display the results
    while ($row = $result->fetch_assoc()) {
        $birth_date = date("jS F", strtotime($row['birth_date']));

        // Check if a photo is set for the user
        $photo = !empty($row['photo']) ? "../jc/" . htmlspecialchars($row['photo']) : "../jc/default_photo.jpg";

        $fullname = htmlspecialchars($row['surname'] . " " . $row['first_name']);

        echo '<div class="card catagory-card">
                <a href="#">
                  <img src="' . htmlspecialchars($photo) . '" style="width: 100%; height: 200px; object-fit: cover;" alt="' . htmlspecialchars($row['surname']) . '">
                  <h6>-' . $fullname . '-</h6>
                  <h6>Date: -' . $birth_date . '-</h6>
                </a>
              </div>';
    }
} else {
    // Display a message if no birthdays are found this week
    echo '<div class="no-results">
            <p>No birthdays found for this week.</p>
          </div>';
}

// Close connection
$stmt->close();
$conn->close();
?>
