<?php
require_once("app-config/DB_config.php");
include("admin-includes/view-application-external.php");
 

if (isset($_POST['validate'])) {
    // Collecting form data
    $service_name = sanitize_input($conn, $_POST['service_name']);
    $service_desc =sanitize_input($conn,  $_POST['service_desc']);
    $day_of_week = sanitize_input($conn, $_POST['day_of_week']); // Assuming 'leader' is actually day of the week field
    $start_time = sanitize_input($conn, $_POST['starttime']);
    $end_time = sanitize_input($conn, $_POST['endtime']);
    $frequency = sanitize_input($conn, $_POST['leader']);  // Assuming 'leader' is also frequency here, adjust name as needed
    $registered_by =$_SESSION['account_number'];  // Replace with dynamic user if available

    
    $logo = handle_logo_upload($conn);
    
    // SQL to insert the data
    $sql = "INSERT INTO service_setup (service_name, service_desc, day_of_week, start_time, end_time, frequency, registered_by, logo) 
            VALUES ('$service_name', '$service_desc', '$day_of_week', '$start_time', '$end_time', '$frequency', '$registered_by', '$logo')";

    if ($conn->query($sql) === TRUE) {
       
          echo '<div class="alert alert-success border-0 bg-grd-success alert-dismissible fade show">
									<div class="d-flex align-items-center">
										<div class="font-35 text-white"><span class="material-icons-outlined fs-2">check_circle</span>
										</div>
										<div class="ms-3">
											<h6 class="mb-0 text-white">Success</h6>
											<div class="text-white">Information Submitted Successfully!!</div>
										</div>
									</div>
									<button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
								</div>';
        
    } else {
//echo "Error: " . $sql . "<br>" . $conn->error;
        
         echo '<div class="alert alert-danger border-0 bg-grd-danger alert-dismissible fade show">
									<div class="d-flex align-items-center">
										<div class="font-35 text-white"><span class="material-icons-outlined fs-2">report_gmailerrorred</span>
										</div>
										<div class="ms-3">
											<h6 class="mb-0 text-white">Error Occurred: </h6>
											<div class="text-white">Database query failed:  '. $sql.'   '.$conn->error.'</div>
										</div>
									</div>
									<button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
								</div>';
    }
}

$conn->close();
 



// Function to sanitize user input
function sanitize_input($conn, $data) {
    return mysqli_real_escape_string($conn, trim($data));
}
function handle_logo_upload($conn) {
    if (basename($_FILES["logo"]["name"]) == "") {
        return trim(mysqli_real_escape_string($conn, $_POST['logo1']));
    } else {
        $target_dir = "uploads/services/";
        $target_file = $target_dir . basename($_FILES["logo"]["name"]);
        $uploadOk = 1;
        $imageFileType = strtolower(pathinfo($target_file, PATHINFO_EXTENSION));

        // Check if image file is a actual image or fake image
        $check = getimagesize($_FILES["logo"]["tmp_name"]);
        if ($check === false) {
            echo "<div class='btn btn-danger btn-lg'>File is not an image.</div><br />";
            $uploadOk = 0;
        }

        // Check if file already exists
        if (file_exists($target_file)) {
            echo "<div class='btn btn-danger btn-lg'>Sorry, file already exists.</div><br />";
            $uploadOk = 0;
        }

        // Check file size
        if ($_FILES["logo"]["size"] > 500000) {
            echo "<div class='btn btn-danger btn-lg'>Sorry, your file is too large.</div><br />";
            $uploadOk = 0;
        }

        // Allow certain file formats
        if (!in_array($imageFileType, ['jpg', 'jpeg', 'png', 'gif'])) {
            echo "<div class='btn btn-danger btn-lg'>Sorry, only JPG, JPEG, PNG & GIF files are allowed.</div><br />";
            $uploadOk = 0;
        }

        if ($uploadOk === 0) {
            return false;
        } else {
            if (move_uploaded_file($_FILES["logo"]["tmp_name"], $target_file)) {
                echo "<div class='btn btn-success btn-lg'>The file " . basename($_FILES["logo"]["name"]) . " has been uploaded.</div>";
                return $target_file;
            } else {
                echo "<div class='btn btn-danger btn-lg'>Sorry, there was an error uploading your file.</div><br />";
                return false;
            }
        }
    }
}
 
?>
