<?php
include("../jc/app-config/DB_config.php"); // Include database connection
include("admin-includes/SendingSMS.php");
include("admin-includes/send-email.php");

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;
use PHPMailer\PHPMailer\Exception;
require 'vendor/autoload.php';

$emailing = $_SESSION['email'] ?? '';

if (isset($_POST["validate"])) {

    // Check if a file was uploaded
    if (isset($_FILES['csv_file']) && is_uploaded_file($_FILES['csv_file']['tmp_name'])) {
        $csv_file = $_FILES['csv_file']['tmp_name'];

        // Open CSV file
        if (($handle = fopen($csv_file, "r")) !== FALSE) {
            fgetcsv($handle); // Skip header row

            while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) {

                // Check if row is empty
                if (empty(array_filter($data))) {
                    continue; // Skip empty rows
                }

                list($title, $surname, $first_name, $gender, $phone_number, $email, $address, $birthdate, $marital_status, $employment, $occupation, $year_join, $talent, $suggestions, $photo_url) = $data;

                // Sanitize data
                $title = sanitize_input($conn, $title);
                $surname = sanitize_input($conn, $surname);
                $first_name = sanitize_input($conn, $first_name);
                $gender = sanitize_input($conn, $gender);
                $phone_number = sanitize_input($conn, "0" . $phone_number);
                $email = sanitize_input($conn, $email);
                $address = sanitize_input($conn, $address);
                $birthdate = date("Y-m-d", strtotime(sanitize_input($conn, $birthdate)));
                $marital_status = sanitize_input($conn, $marital_status);
                $employment = sanitize_input($conn, $employment);
                $occupation = sanitize_input($conn, $occupation);
                $year_join = sanitize_input($conn, $year_join);
                $talent = sanitize_input($conn, $talent);
                $suggestions = sanitize_input($conn, $suggestions);

                // Latitude and Longitude handling
                $coordinates = getCoordinates($address, $googleapi);
                $lati = $coordinates ? $coordinates['latitude'] : '0';
                $longi = $coordinates ? $coordinates['longitude'] : '0';

                // Check for duplicates based on phone_number
                $check_query = "SELECT id FROM jc_members WHERE phone_number = ?";
                $check_stmt = $conn->prepare($check_query);
                $check_stmt->bind_param("s", $phone_number);
                $check_stmt->execute();
                $check_stmt->store_result();

                if ($check_stmt->num_rows > 0) {
                    echo "<div class='alert alert-warning'>Duplicate entry found for $phone_number. Skipping.</div>";
                    continue;
                }

                // Google Drive photo download
                $target_dir = "uploads/" . date('Y') . "/";
                if (!file_exists($target_dir)) {
                    mkdir($target_dir, 0777, true);
                }
                $unique_photo_name = uniqid('JC_', true) . ".jpg";
                $target_file = $target_dir . $unique_photo_name;

                if (!empty($photo_url)) {
                    preg_match('/\/d\/(.*?)\//', $photo_url, $matches);
                    $file_id = $matches[1] ?? '';
                    $download_url = "https://drive.google.com/uc?export=download&id=" . $file_id;

                    $photo_data = @file_get_contents($download_url);
                    if ($photo_data !== FALSE) {
                        file_put_contents($target_file, $photo_data);
                    } else {
                        echo "<div class='alert alert-danger'>Failed to download photo for $first_name $surname. Skipping entry.</div>";
                      //  continue;
                    }
                }

                // Encrypt password
                $password = "123456";
                $encrypted_password_data = encryptPassword($password);
                $encrypted_password = $encrypted_password_data['encrypted'] ?? '';
                $salt = $encrypted_password_data['salt'] ?? '';
                $worker_id = "JC-" . mt_rand(100000, 999999);

                // Define irrelevant value
                $irrelevant = 0;

                // Prepare and execute SQL query
                $query = "INSERT INTO jc_members (title, surname, first_name, gender, phone_number, email, address, birthdate, marital_status, employment, occupation, year_join, talent, suggestions, photo, lati, longi, unique_id, encrypted_password, salt, irrelivant, password_update) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                $stmt = $conn->prepare($query);
                $stmt->bind_param(
                    "ssssssssssssssssssssss", 
                    $title, 
                    $surname, 
                    $first_name, 
                    $gender, 
                    $phone_number, 
                    $email, 
                    $address, 
                    $birthdate, 
                    $marital_status, 
                    $employment, 
                    $occupation, 
                    $year_join, 
                    $talent, 
                    $suggestions, 
                    $target_file, 
                    $lati, 
                    $longi, 
                    $worker_id, 
                    $encrypted_password, 
                    $salt, 
                    $password, 
                    $irrelevant
                );

                if ($stmt->execute()) {
                    echo "<div class='alert alert-success'>Information for $phone_number submitted successfully.</div>";
                } else {
                    echo "<div class='alert alert-danger'>Failed to submit information for $phone_number.</div>";
                }
            }
            fclose($handle);
        }
    } else {
        echo "<div class='alert alert-danger'>Please upload a CSV file.</div>";
    }
}

// Sanitize input function
function sanitize_input($conn, $data) {
    return mysqli_real_escape_string($conn, trim($data));
}

// Password encryption function
function encryptPassword($password) {
    $salt = substr(sha1(rand()), 0, 10);
    $encrypted = base64_encode(sha1($password . $salt, true) . $salt);
    return ['encrypted' => $encrypted, 'salt' => $salt];
}

// Retrieve coordinates from Google API
function getCoordinates($address, $apiKey) {
    $address = urlencode($address);
    $url = "https://maps.googleapis.com/maps/api/geocode/json?address={$address}&key={$apiKey}";

    $response = file_get_contents($url);
    $response = json_decode($response, true);

    if ($response['status'] == 'OK') {
        $latitude = $response['results'][0]['geometry']['location']['lat'];
        $longitude = $response['results'][0]['geometry']['location']['lng'];
        return ['latitude' => $latitude, 'longitude' => $longitude];
    } else {
        return null;
    }
}
?>
