<?php
include("app-config/DB_config.php");
$myName = new Name();

 
$emailing = isset($_SESSION['email']) ? $_SESSION['email'] : '';

// Function to get live_service data securely
function getlive_serviceData($conn) {
    $query = "SELECT  `id`, `url`, `service_type`, `descpription`, `created_date`, `registeredby` , `status` FROM `live_service` ORDER BY `id` DESC";
    $stmt = $conn->prepare($query);
    $stmt->execute();
    $result = $stmt->get_result();
    return $result;
}

// Fetch live_service data
$live_services = getlive_serviceData($conn);
$count = $live_services->num_rows;

if ($count > 0) {
    while ($row = $live_services->fetch_assoc()) {
        $id = htmlspecialchars($row['id']);
        $url = htmlspecialchars($row['url']);
        $service_type = htmlspecialchars($row['service_type']);
        $descpription = htmlspecialchars($row['descpription']);
     
        $status = htmlspecialchars($row['status']);
        $created_date = htmlspecialchars($row['created_date']);
        $registeredby = htmlspecialchars($row['registeredby']);

        $statusCSS = $status == 1 ? "badge bg-grd-success" : "badge bg-grd-danger";
        $statusParam = $status == 1 ? "Active" : "Not Active";
 $service_name = $myName->showName($conn, "SELECT `service_name` FROM `service_setup` WHERE `id` = '$service_type'");
 $registeredby = $myName->showName($conn, "SELECT `name` FROM `user_unit` WHERE `account_number` = '$registeredby'");
        echo '<tr>
            <td><a href="?value=' . $id . '"> <strong>' . $url . '</strong> </a></td>
            <td>' . $service_name . '</td>
           
            <td>' . $created_date . '</td>
            <td>' . $registeredby . '</td>
            <td> <span class="' . $statusCSS . '">' . $statusParam . ' </span> </td>
            <td>
                <div class="btn-group">
                    <button class="btn btn-warning text-black dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">Options</button>
                    <ul class="dropdown-menu dropdown-block">
                        <li><a class="dropdown-item" onclick="return confirm(\'Are you sure you want to delete?\')" href="?table=live_service&del=' . $id . '">Delete</a></li>
                        <li><a class="dropdown-item" onclick="return confirm(\'Are you sure you want to update?\')" href="?table=live_service&id=' . $id . '&columnValue=1&column=status">Activate</a></li>
                        <li><a class="dropdown-item" onclick="return confirm(\'Are you sure you want to update?\')" href="?table=live_service&id=' . $id . '&columnValue=0&column=status">Deactivate</a></li>
                    </ul>
                </div>
            </td>
        </tr>';
    }
} else {
    echo '<tr><td colspan="9">No records found.</td></tr>';
}
?>
