<?php
include("app-config/DB_config.php");
$myName = new Name();

// Check if the session has a user email
$emailing = isset($_SESSION['email']) ? $_SESSION['email'] : '';

// Function to fetch pouchi setup data
function getDetails($conn) {
    $query = "SELECT `id`, `service_date`, `service_type`, `giving_type`, SUM(`amount`) AS amount, `status`, `created_date`, `registeredby` 
              FROM `offering` 
              GROUP BY `service_date` 
              ORDER BY `id` DESC LIMIT 10";
    $stmt = $conn->prepare($query);
    
    if ($stmt) {
        $stmt->execute();
        $result = $stmt->get_result();
        return $result;
    } else {
        echo "Error: " . $conn->error;
        return false;
    }
}

// Fetch pouchi setup data
$pouchiSetups = getDetails($conn);

if ($pouchiSetups && $pouchiSetups->num_rows > 0) {
    while ($row = $pouchiSetups->fetch_assoc()) {
        // Escaping output
        $id = htmlspecialchars($row['id']);
        $service_date = htmlspecialchars($row['service_date']);
        $service_setup = htmlspecialchars($row['service_type']);
        $giving_type = htmlspecialchars($row['giving_type']);
        $amount = htmlspecialchars($row['amount']);
        $registeredby = htmlspecialchars($row['registeredby']);
        $created_date = htmlspecialchars($row['created_date']);
        $status = htmlspecialchars($row['status']);

        // Status details
        $statusCSS = $status == 1 ? "badge bg-grd-success" : "badge bg-grd-danger";
        $statusParam = $status == 1 ? "Active" : "Not Active";
        
        // Fetch related data
        $service_name = htmlspecialchars($myName->showName($conn, "SELECT `service_name` FROM `service_setup` WHERE `id` = '$service_setup'"));
        $giving_type_name = htmlspecialchars($myName->showName($conn, "SELECT `name` FROM `giving_type` WHERE `id` = '$giving_type'"));
        $registeredby_name = htmlspecialchars($myName->showName($conn, "SELECT `name` FROM `user_unit` WHERE `account_number` = '$registeredby'"));
        
        // Output table row
        echo '<tr>
            <td><a href="?value=' . $id . '"> <strong>' . $service_date . '</strong> </a></td>
            <td>' . $service_name . '</td>
           
            <td> &#8358; ' . number_format(floatval($amount)) . '</td>
            <td>' . $created_date . '</td>
           
            <td> <span class="' . $statusCSS . '">' . $statusParam . ' </span> </td>
           
        </tr>';
    }
} else {
    echo '<tr><td colspan="13">No records found.</td></tr>';
}

// Close the connection
//$conn->close();
?>
