<?php
include("app-config/DB_config.php");
$myName = new Name();

$emailing = isset($_SESSION['email']) ? $_SESSION['email'] : '';

 

function getDetails($conn) {
    $query = "SELECT `id`, `service_date`, `service_type`, `giving_type`, `amount`, `status`, `created_date`, `registeredby` FROM `offering` ORDER BY `id` DESC";
    $stmt = $conn->prepare($query);
    $stmt->execute();
    $result = $stmt->get_result();
    return $result;
}

// Fetch pouchi setup data
$pouchiSetups = getDetails($conn);
$count = $pouchiSetups->num_rows;

if ($count > 0) {
    while ($row = $pouchiSetups->fetch_assoc()) {
        
  
        
        $id = htmlspecialchars($row['id']);
        $service_date = htmlspecialchars($row['service_date']);
        $service_setup = htmlspecialchars($row['service_type']);
        $giving_type = htmlspecialchars($row['giving_type']);
        $amount = htmlspecialchars($row['amount']);
       
     $registeredby = htmlspecialchars($row['registeredby']);
        $created_date = htmlspecialchars($row['created_date']);
        $status = htmlspecialchars($row['status']);
      

        $statusCSS = $status == 1 ? "badge bg-grd-success" : "badge bg-grd-danger";
        $statusParam = $status == 1 ? "Active" : "Not Active";
        
        
         $service_name = $myName->showName($conn, "SELECT `service_name` FROM `service_setup` WHERE `id` = '$service_setup'"); 
        
        $giving_type = $myName->showName($conn, "SELECT `name` FROM `giving_type` WHERE `id` = '$giving_type'"); 
        
        
         $registeredby = $myName->showName($conn, "SELECT `name` FROM `user_unit` WHERE `account_number` =  '$registeredby'"); 
        
         

        echo '<tr>
            <td><a href="?value=' . $id . '"> <strong>' . $service_date . '</strong> </a></td>
            <td>' . $service_name . '</td>
            <td>' . $giving_type . '</td>
            <td> &#8358; ' . number_format(floatval($amount)) . '</td>
           
           
             <td>' . $created_date . '</td>
            <td>' . $registeredby . '</td>
            <td> <span class="' . $statusCSS . '">' . $statusParam . ' </span> </td>
            <td>
                <div class="btn-group">
                    <button class="btn btn-warning text-black dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">Options</button>
                    <ul class="dropdown-menu dropdown-block">
                        <li><a class="dropdown-item" onclick="return confirm(\'Are you sure you want to delete?\')" href="?table=offering&del=' . $id . '">Delete</a></li>
                        <li><a class="dropdown-item" onclick="return confirm(\'Are you sure you want to update?\')" href="?table=offering&id=' . $id . '&columnValue=1&column=status">Activate</a></li>
                        <li><a class="dropdown-item" onclick="return confirm(\'Are you sure you want to update?\')" href="?table=offering&id=' . $id . '&columnValue=0&column=status">Deactivate</a></li>
                    </ul>
                </div>
            </td>
        </tr>';
    }
} else {
    echo '<tr><td colspan="13">No records found.</td></tr>';
}

//$conn->close();
?>
