<?php
include("app-config/DB_config.php");

$myName = new Name();

$emailing = isset($_SESSION['email']) ? $_SESSION['email'] : '';

// Ensure we have sanitized inputs
$date = isset($_GET['date']) ? $_GET['date'] : '';
$service_type = isset($_GET['service_type']) ? $_GET['service_type'] : '';

// Function to fetch details of workers who have not marked attendance
function getDetails2($conn, $date, $service_type) {
    // Use placeholders for prepared statements
    $query = "SELECT 
        w.id, 
        w.worker_id, 
        w.surname, 
        w.first_name, 
        w.phone_number, 
        w.email_address, 
        w.home_address,
        a.service_id,
        w.family,
        w.department
    FROM 
        js_workers w
    LEFT JOIN 
        attendance_log a 
    ON 
        w.worker_id = a.registered_by 
        AND DATE(a.created_date) = ? 
        AND a.service_id = ? 
    WHERE 
        a.registered_by IS NULL AND  w.status = 1";

    // Prepare the statement
    $stmt = $conn->prepare($query);
    if ($stmt) {
        // Bind the parameters
        $stmt->bind_param('si', $date, $service_type); // 'si' = string, integer
        $stmt->execute();
        $result = $stmt->get_result();
        return $result;
    } else {
        // Handle query preparation error
        echo "Error preparing the query: " . $conn->error;
        return false;
    }
}

// Fetch workers' data who have not marked attendance
$pouchiSetups = getDetails2($conn, $date, $service_type);
if ($pouchiSetups && $pouchiSetups->num_rows > 0) {
    while ($row = $pouchiSetups->fetch_assoc()) {
        // Safely escape the output with htmlspecialchars
        $id = htmlspecialchars($row['id'], ENT_QUOTES, 'UTF-8');
        $worker_id = htmlspecialchars($row['worker_id'], ENT_QUOTES, 'UTF-8');
        $surname = htmlspecialchars($row['surname'], ENT_QUOTES, 'UTF-8');
        $first_name = htmlspecialchars($row['first_name'], ENT_QUOTES, 'UTF-8');
        $phone_number = htmlspecialchars($row['phone_number'], ENT_QUOTES, 'UTF-8');
        $email_address = htmlspecialchars($row['email_address'], ENT_QUOTES, 'UTF-8');
        $department = htmlspecialchars($row['department'], ENT_QUOTES, 'UTF-8');
      //  $service_id = htmlspecialchars($row['service_id'], ENT_QUOTES, 'UTF-8');
        $family = htmlspecialchars($row['family'], ENT_QUOTES, 'UTF-8');

        // Retrieve meeting and department names dynamically
       // $meeting_name = $myName->showName($conn, "SELECT `meeting_name` FROM `workers_meeting` WHERE `id` = ?", $service_id);
        $department_name = $myName->showName($conn, "SELECT `department_name` FROM `department` WHERE `id` = '$department'");
        $family_group_name = $myName->showName($conn, "SELECT `name` FROM `family_group` WHERE `id` ='$family'");

        // Encode the ID for URL safety
        $id_enc = strtr(base64_encode($id), '+/=', '-_,');

        // Output the worker details in HTML table row format
        echo '<tr>
                <td><a href="jc-view-workers-details?worker=' . $id_enc . '"><strong>' . $surname . ' ' . $first_name . '</strong></a></td>
                <td><a href="tel:' . $phone_number . '"><strong>Call: ' . $phone_number . '</strong></a></td>
                <td>' . $email_address . '</td>
                <td>' . $department_name . '</td>
                <td>' . $family_group_name . '</td>
              </tr>';
    }
} else {
    // Handle case where no records are found
    echo '<tr><td colspan="5">No records found for the given date and service type.</td></tr>';
}

// Close the database connection
$conn->close();
?>
 
