<?php
include("app-config/DB_config.php");
$myName = new Name();

if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

$sql = "SELECT * FROM workers_in_training";
$result = $conn->query($sql);

if ($result->num_rows > 0) {    
    while ($row = $result->fetch_assoc()) {
        $generation_id = $row["generation_name"];
        $department1 = $row["department1"];
        $department2 = $row["department2"];
        $status = $row['status'];

        // Fetch additional names using helper function
        $generation_name = $myName->showName($conn, "SELECT `name` FROM `generation` WHERE `id` = '$generation_id'"); 
        $department1_name = $myName->showName($conn, "SELECT `department_name` FROM `department` WHERE `id` = '$department1'");  
        $department2_name = $myName->showName($conn, "SELECT `department_name` FROM `department` WHERE `id` = '$department2'"); 

        // Status CSS class and label
        $statusCSS = $status == 1 ? "badge bg-grd-success" : "badge bg-grd-danger";
        $statusParam = $status == 1 ? "Active" : "Not Active";

        // Decode JSON fields (if applicable)
        $previous_churches = json_decode($row["previous_churches"], true);
        $previous_churches = is_array($previous_churches) ? implode(", ", $previous_churches) : $row["previous_churches"];

        $rccg_other_parishes = json_decode($row["rccg_other_parishes"], true);
        $rccg_other_parishes = is_array($rccg_other_parishes) ? implode(", ", $rccg_other_parishes) : $row["rccg_other_parishes"];

        echo "<tr>
                <td>{$generation_name}</td>
                <td>{$row["surname"]}</td>
                <td>{$row["first_name"]}</td>
                <td>{$row["dob"]}</td>
                <td>{$row["age"]}</td>
                <td>{$row["home_address"]}</td>
                <td>{$row["sex"]}</td>
                <td>{$row["marital_status"]}</td>
                <td>{$row["tel"]}</td>
                <td>{$row["email"]}</td>
                <td>{$row["profession"]}</td>
                <td>{$row["position"]}</td>
                <td>{$row["work_address"]}</td>
                <td>{$row["born_again"]}</td>
                <td>{$row["born_again_date"]}</td>
                <td>{$row["born_again_where"]}</td>
                <td>{$row["holy_ghost_baptism"]}</td>
                <td>{$row["baptism_date"]}</td>
                <td>{$row["speaking_in_tongue"]}</td>
                <td>{$row["water_baptism"]}</td>
                <td>{$row["water_baptism_date"]}</td>
                <td>{$row["water_baptism_where"]}</td>
                <td>{$previous_churches}</td>
                <td>{$row["rccg_membership_date"]}</td>
                <td>{$row["rccg_joined_parish"]}</td>
                <td>{$rccg_other_parishes}</td>
                <td>{$row["schools_attended"]}</td>
                <td>{$row["education_date"]}</td>
                <td>{$row["qualification"]}</td>
                <td>{$department1_name}</td>
                <td>{$department2_name}</td>
                <td><img src='{$row["signature"]}' style='width: 100px; height: 100px;'></td>
                <td>{$row["promise"]}</td>
                <td>{$row["created_at"]}</td>
                <td><span class='{$statusCSS}'>{$statusParam}</span></td>
            </tr>";
    }
} else {
    echo "<tr><td colspan='35'>No records found.</td></tr>";
}

$conn->close();
?>
