<?php

$emailing = "";
include("admin-includes/view-application-external.php");

if (isset($_POST['validate'])) {

    if (isset($_SESSION['email'])) {
        $emailing = $_SESSION['email'];
    }

    $location_name = sanitize_input($conn, $_POST['location_name']);
    $location_address = sanitize_input($conn, $_POST['location_address']);
    $amount = $_POST['amount'];

    $status = '1';
    $datetime = date('Y-m-d H:i:s');
    $registeredby = $emailing;
    
    $lati = "";
    $longi = "";
    
    $coordinates = getCoordinates($location_address, $googleapi);

    if ($coordinates) {
        $lati = $coordinates['latitude'];
        $longi = $coordinates['longitude'];
    } else {
        $lati = "";
        $longi = "";
    }
    
    // Handle the file upload
    $uploadDirectory = "uploads/";
    $uploadedFiles = [];

    foreach ($_FILES['pictures']['name'] as $key => $filename) {
        $targetFilePath = $uploadDirectory . basename($filename);
        $fileType = pathinfo($targetFilePath, PATHINFO_EXTENSION);

        if (move_uploaded_file($_FILES['pictures']['tmp_name'][$key], $targetFilePath)) {
            $uploadedFiles[] = $targetFilePath;
        }
    }

    $images = implode(',', $uploadedFiles);

    if (record_exists($conn, $location_name)) {
        $result = update_location($conn, $status, $datetime, $location_name, $registeredby, $location_address, $longi, $lati, $images, $amount);
    } else {
        $result = insert_location($conn, $status, $datetime, $location_name, $registeredby, $location_address, $longi, $lati, $images, $amount);
     
        $last_id = $conn->insert_id;

        // Insert Landmarks
        $landmarks = $_POST['landmark'];
        $distances = $_POST['distance'];
        $stmt = $conn->prepare("INSERT INTO location_landmark (`location_id`, `landmark`, `distance`, `status`, `created_at`) VALUES (?, ?, ?, ?, ?)");
        for ($i = 0; $i < count($landmarks); $i++) {
            $stmt->bind_param("issss", $last_id, $landmarks[$i], $distances[$i], $status, $datetime);
            $stmt->execute();
        }

        // Insert "At a Glance" Information
        $glance_info = $_POST['glance'];
        $stmt_glance = $conn->prepare("INSERT INTO location_glance (`location_id`, `glance_info`, `status`, `created_at`) VALUES (?, ?, ?, ?)");
        for ($i = 0; $i < count($glance_info); $i++) {
            $stmt_glance->bind_param("isss", $last_id, $glance_info[$i], $status, $datetime);
            $stmt_glance->execute();
        }

        $stmt->close();
        $stmt_glance->close();
        $conn->close();
    }

    if ($result) {
         echo '<div class="alert alert-success border-0 bg-grd-success alert-dismissible fade show">
									<div class="d-flex align-items-center">
										<div class="font-35 text-white"><span class="material-icons-outlined fs-2">check_circle</span>
										</div>
										<div class="ms-3">
											<h6 class="mb-0 text-white">Success</h6>
											<div class="text-white">Information Submitted Successfully</div>
										</div>
									</div>
									<button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
								</div>';
    } else {
        echo '<a href="#" class="btn btn-danger btn-lg">Information Not Submitted Successfully. <br />Please try again later.</a><br />';
    }
}

function sanitize_input($conn, $data) {
    return mysqli_real_escape_string($conn, trim($data));
}

function record_exists($conn, $location_name) {
    $query = "SELECT * FROM location WHERE name = ?";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("s", $location_name);
    $stmt->execute();
    $result = $stmt->get_result();
    return $result->num_rows > 0;
}

function update_location($conn, $status, $datetime, $location_name, $registeredby, $location_address, $longi, $lati, $images, $amount) {
    $stmt = $conn->prepare("UPDATE location SET status = ?, created_at = ?, name = ?, registeredby = ?, address = ?, longi = ?, lati = ?, images = ?, amount = ? WHERE name = ?");
    $stmt->bind_param("ssssssssss", $status, $datetime, $location_name, $registeredby, $location_address, $longi, $lati, $images, $amount, $location_name);
    return $stmt->execute();
}

function insert_location($conn, $status, $datetime, $location_name, $registeredby, $location_address, $longi, $lati, $images, $amount) {
    $stmt = $conn->prepare("INSERT INTO location (`status`, `created_at`, `name`, `registeredby`, `address`, `longi`, `lati`, `images`, `amount`) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
    $stmt->bind_param("sssssssss", $status, $datetime, $location_name, $registeredby, $location_address, $longi, $lati, $images, $amount);
    return $stmt->execute();
}

function getCoordinates($address, $apiKey) {
    $address = urlencode($address);
    $url = "https://maps.googleapis.com/maps/api/geocode/json?address={$address}&key={$apiKey}";

    $response = file_get_contents($url);
    $response = json_decode($response, true);

    if ($response['status'] == 'OK') {
        $latitude = $response['results'][0]['geometry']['location']['lat'];
        $longitude = $response['results'][0]['geometry']['location']['lng'];
        return ['latitude' => $latitude, 'longitude' => $longitude];
    } else {
        return null;
    }
}
?>
