<?php
date_default_timezone_set('Africa/Lagos');
//session_start();
$today = date("Y-m-d"); 
$todaydatefull = date('Y-m-d G:i:s');

// Unset session values for a fresh login
unset($_SESSION['email'], $_SESSION['emailadd'], $_SESSION['name']);

$errinput_arr = [];
$errcatch_flag = false;
$username = "";

global $error, $success, $error2;

// Check if login form is submitted
if (isset($_POST['login'])) {
    $password = trim($_POST['password']);
    $username = trim($_POST['username']);

    // Validate input
    if (empty($username)) {
        $errinput_arr[] = '<div class="alert alert-danger">Username is required.</div>';
        $errcatch_flag = true;
    } else if (empty($password)) {
        $errinput_arr[] = '<div class="alert alert-danger">Password is required.</div>';
        $errcatch_flag = true;
    }

    if ($errcatch_flag) {
        $error = $errinput_arr;
    } else {
        // Use prepared statements for SQL queries
        $stmt = $conn->prepare("SELECT * FROM `customer` WHERE (`account_number` = ? OR `email` = ? OR `phone` = ?) AND `status` = 1");
        $stmt->bind_param('sss', $username, $username, $username);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result && $result->num_rows == 1) {
            $customer = $result->fetch_assoc();

            $emailing = $customer['account_number'];
            $emailAdd = $customer['email']; 
            $phoneNumber = $customer['phone']; 
            $encrypted_password = $customer['encrypted_password'];
            $salt = $customer['salt'];
            $hash = base64_encode(sha1($password . $salt, true) . $salt);

            // Verify password securely
            if (hash_equals($encrypted_password, $hash)) {
                $_SESSION['identify'] = $customer['id'];
                $_SESSION['phone_number'] = $customer['phone'];
                $_SESSION['account_number'] = $customer['account_number'];
                $_SESSION['usertype'] = $customer['usertype'];
                $_SESSION['fullname'] = $customer['name'];
                $_SESSION['email'] = $customer['account_number'];

                // Redirect to dashboard or change password if needed
                if ($customer['password_update'] == 1) {
                    log_login($conn, $username, $todaydatefull);
                    handle_remember_me($_POST['username'], $_POST['password']);
                    redirect_to_dashboard();
                } else {
                    $_SESSION['type'] = 1;
                    header("Location: change-pwd");
                    exit();
                }
            } else {
                $error2 = display_error("Invalid login details. Please try again.");
            }
        } else {
            $error2 = display_error("Invalid login details. Please try again.");
        }
    }
}

// Function to handle login log entry
function log_login($conn, $username, $todaydatefull) {
    $ipaddress = getenv('HTTP_X_FORWARDED_FOR') ?: getenv('REMOTE_ADDR');
    $stmt = $conn->prepare("INSERT INTO `login_log` (`username`, `ip_address`, `login`, `platform`, `status`) VALUES (?, ?, ?, 'Web Admin', '0')");
    $stmt->bind_param('sss', $username, $ipaddress, $todaydatefull);
    $stmt->execute();
}

// Function to handle "Remember Me" functionality
function handle_remember_me($username, $password) {
    if (isset($_POST['remember'])) {
        $year = time() + 31536000;
        setcookie('remember_me', $username, $year);
        setcookie('password_me', $password, $year);
    } else {
        // Unset cookies if "Remember Me" is not checked
        if (isset($_COOKIE['remember_me'])) {
            setcookie('remember_me', '', time() - 100);
            setcookie('password_me', '', time() - 100);
        }
    }
}

// Function to redirect to dashboard
function redirect_to_dashboard() {
    $acct = strtr(base64_encode($_SESSION['account_number']), '+/=)(*&^%$#@!)', '-_,)(*&^%$#@!)');
    $type = strtr(base64_encode(1), '+/=)(*&^%$#@!)', '-_,)(*&^%$#@!)');
    header("Location: dashboard?user=$acct&type=$type");
    exit();
}

// Function to display error messages
function display_error($message) {
    return '<div class="alert alert-danger">' . $message . '</div>';
}
?>
