<?php

include("app-config/DB_config.php");

if (isset($_POST['validate'])) {
    
    // Check if user is logged in
    if (isset($_SESSION['email'])) {
        $email = $_SESSION['email'];
    } else {
       // die('<a href="#" class="btn btn-danger btn-lg">User not authenticated. Please log in.</a><br />');
    }
    
    // Sanitize and fetch POST data
    $name = mysqli_real_escape_string($conn, $_POST['name']);
    $super = mysqli_real_escape_string($conn, $_POST['super']);
    $url = mysqli_real_escape_string($conn, $_POST['url']);
    $status = mysqli_real_escape_string($conn, $_POST['status']);
    $icon = mysqli_real_escape_string($conn, $_POST['icon']);
    $datetime = date('Y-m-d H:i:s');  // Make sure to define the current datetime format

    // Check if the menu item already exists in the database
    $stmt = $conn->prepare("SELECT * FROM `menu` WHERE `name` = ?");
    $stmt->bind_param('s', $name);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result->num_rows > 0) {
        echo '<a href="#" class="btn btn-danger btn-lg">Information is already in the database. <br />Please check and try again later.</a><br />';
    } else {
        // Insert new menu item into the database using prepared statements
        $stmt = $conn->prepare("INSERT INTO `menu`(`name`, `url`, `super_menu`, `status`, `created_date`, `registeredby`, `icon`) VALUES (?, ?, ?, ?, ?, ?, ?)");
        $stmt->bind_param('sssssss', $name, $url, $super, $status, $datetime, $email, $icon);
        
        if ($stmt->execute()) {
             echo '<div class="alert alert-success border-0 bg-grd-success alert-dismissible fade show">
									<div class="d-flex align-items-center">
										<div class="font-35 text-white"><span class="material-icons-outlined fs-2">check_circle</span>
										</div>
										<div class="ms-3">
											<h6 class="mb-0 text-white">Success</h6>
											<div class="text-white">Information Submitted Successfully</div>
										</div>
									</div>
									<button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
								</div>';
        } else {
            echo '<a href="#" class="btn btn-danger btn-lg">Information Not Submitted Successfully. <br />Please try again later.</a><br />';
        }
    }
    
    // Close the prepared statement
    $stmt->close();
}

// Close the database connection
$conn->close();

?>
