<?php

$emailing = "";
   
    
// Handle form submission
if (isset($_POST['validate'])) {

  if (isset($_SESSION['email'])) {
        $emailing = $_SESSION['email'];
    }  $requestChannelId = sanitize_input($conn, $_POST['requestChannelId']);
    $requestChannel = sanitize_input($conn, $_POST['requestChannel']);
    $requestChannelType = sanitize_input($conn, $_POST['requestChannelType']);
    $requestApplicationCode = sanitize_input($conn, $_POST['requestApplicationCode']);
    $requestApplicationModule = sanitize_input($conn, $_POST['requestApplicationModule']);
    $requestPartnerCode = sanitize_input($conn, $_POST['requestPartnerCode']);
    $username = sanitize_input($conn, $_POST['username']);
    $password = sanitize_input($conn, $_POST['password']);
    $url = sanitize_input($conn, $_POST['url']);
    $rememberMe = isset($_POST['rememberMe']) ? 'true' : 'false';
    $status = '0';
    $datetime = date('Y-m-d H:i:s');
    $registeredby = $emailing;

    if (record_exists($conn, $requestChannelId)) {
        $result = update_pouchi_setup($conn, $requestChannelId, $requestChannel, $requestChannelType, $requestApplicationCode, $requestApplicationModule, $requestPartnerCode, $username, $password, $rememberMe, $status, $datetime, $registeredby, $url);
    } else {
        $result = insert_pouchi_setup($conn, $requestChannelId, $requestChannel, $requestChannelType, $requestApplicationCode, $requestApplicationModule, $requestPartnerCode, $username, $password, $rememberMe, $status, $datetime, $registeredby, $url);
    }

    if ($result) {
         echo '<div class="alert alert-success border-0 bg-grd-success alert-dismissible fade show">
									<div class="d-flex align-items-center">
										<div class="font-35 text-white"><span class="material-icons-outlined fs-2">check_circle</span>
										</div>
										<div class="ms-3">
											<h6 class="mb-0 text-white">Success</h6>
											<div class="text-white">Information Submitted Successfully</div>
										</div>
									</div>
									<button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
								</div>';
    } else {
        echo '<a href="#" class="btn btn-danger btn-lg">Information Not Submitted Successfully. <br />Please try again later.</a><br />';
    }

    $conn->close();
}

function sanitize_input($conn, $data) {
    return mysqli_real_escape_string($conn, trim($data));
}

function record_exists($conn, $requestChannelId) {
    $query = "SELECT * FROM pouchi_setup WHERE requestChannelId = ?";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("s", $requestChannelId);
    $stmt->execute();
    $result = $stmt->get_result();
    return $result->num_rows > 0;
}

function update_pouchi_setup($conn, $requestChannelId, $requestChannel, $requestChannelType, $requestApplicationCode, $requestApplicationModule, $requestPartnerCode, $username, $password, $rememberMe, $status, $datetime, $registeredby, $url) {
    $stmt = $conn->prepare("UPDATE pouchi_setup SET requestChannel = ?, requestChannelType = ?, requestApplicationCode = ?, requestApplicationModule = ?, requestPartnerCode = ?, username = ?, password = ?, rememberMe = ?, status = ?, created_date = ?, registeredby = ?, url = ? WHERE requestChannelId = ?");
    $stmt->bind_param("sssssssssssss", $requestChannel, $requestChannelType, $requestApplicationCode, $requestApplicationModule, $requestPartnerCode, $username, $password, $rememberMe, $status, $datetime, $registeredby,$url, $requestChannelId);
    return $stmt->execute();
}

function insert_pouchi_setup($conn, $requestChannelId, $requestChannel, $requestChannelType, $requestApplicationCode, $requestApplicationModule, $requestPartnerCode, $username, $password, $rememberMe, $status, $datetime, $registeredby, $url) {
    $stmt = $conn->prepare("INSERT INTO pouchi_setup (requestChannelId, requestChannel, requestChannelType, requestApplicationCode, requestApplicationModule, requestPartnerCode, username, password, rememberMe, status, created_date, registeredby, url) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
    $stmt->bind_param("sssssssssssss", $requestChannelId, $requestChannel, $requestChannelType, $requestApplicationCode, $requestApplicationModule, $requestPartnerCode, $username, $password, $rememberMe, $status, $datetime, $registeredby, $url);
    return $stmt->execute();
}

?>
 