<?php
include("../pl/app-config/DB_config.php");
$myName = new Name();

$emailing = isset($_SESSION['account_number']) ? $_SESSION['account_number'] : '';
$query = '';
$value = '';
 
    $query = "SELECT `id`, `order_code`, `account_number`, `check_in`, `check_out`, `guests`, `payment_type`, `room`, `boooking_type`, `created_date`, `registeredby`, `status`, `special_note` 
              FROM `booking` WHERE `status` IN  (2,3,4,5)
              ORDER BY `id` DESC";
 

 

function getReport($conn, $query) {
    $stmt = $conn->prepare($query);
    $stmt->execute();
    $result = $stmt->get_result();
    return $result;
}

// Fetch booking data
$pouchiSetups = getReport($conn, $query);
$count = $pouchiSetups->num_rows;

if ($count > 0) {
    while ($row = $pouchiSetups->fetch_assoc()) {
        $id = htmlspecialchars($row['id']);
        $order_code = htmlspecialchars($row['order_code']);
        $account_number = htmlspecialchars($row['account_number']);
        $check_in = htmlspecialchars($row['check_in']);
        $check_out = htmlspecialchars($row['check_out']);
        $guests = htmlspecialchars($row['guests']);
        $payment_type = htmlspecialchars($row['payment_type']);
        $room = htmlspecialchars($row['room']);
        $boooking_type = htmlspecialchars($row['boooking_type']);
        $created_date = htmlspecialchars($row['created_date']);
        $registeredby = htmlspecialchars($row['registeredby']);
        $status = htmlspecialchars($row['status']);
        $special_note = htmlspecialchars($row['special_note']);

        // Determine payment type label
        $payment_type_value = "";
        if ($payment_type == 1) {
            $payment_type_value = "Cash";
        } else if ($payment_type == 2) {
            $payment_type_value = "Transfer";
        } else if ($payment_type == 3) {
            $payment_type_value = "Online Payment";
        }

        // Determine booking status CSS class and label
        $statusCSS = "";
        $statusParam = "";
        if ($status == 1) {
            $statusParam = "Active";
            $statusCSS = "badge bg-grd-warning";
            
            $value = '<li><a class="dropdown-item" onclick="return confirm(\'Are you sure you want to update?\')" href="?table=booking&id=' . $id . '&columnValue=2&column=status">Paid</a></li>';
        } else if ($status == 2) {
            $statusParam = "Paid";
            $statusCSS = "badge bg-grd-success";
             $value = '<li><a class="dropdown-item" onclick="return confirm(\'Are you sure you want to update?\')" href="?table=booking&id=' . $id . '&columnValue=3&column=status">Checked In</a></li>';
            
        } else if ($status == 3) {
            $statusParam = "Checked In";
            $statusCSS = "badge bg-grd-success";
            
             $value = '<li><a class="dropdown-item" onclick="return confirm(\'Are you sure you want to update?\')" href="?table=booking&id=' . $id . '&columnValue=5&column=status">Checked Out</a></li>';
            
            $value .= '<li><a class="dropdown-item" onclick="return confirm(\'Are you sure you want to update?\')" href="?table=booking&id=' . $id . '&columnValue=4&column=status">Over Stayed</a></li>';
        } else if ($status == 4) {
            $statusParam = "Over Stayed";
            $statusCSS = "badge bg-grd-danger";
            
             $value = '<li><a class="dropdown-item" onclick="return confirm(\'Are you sure you want to update?\')" href="?table=booking&id=' . $id . '&columnValue=5&column=status">Checked Out</a></li>';
        } else if ($status == 5) {
            $statusParam = "Checked  Out";
            $statusCSS = "badge bg-grd-success";
        } else if ($status == 6) {
            $statusParam = "Payment Failed";
            $statusCSS = "badge bg-grd-danger";
             $value = '<li><a class="dropdown-item" onclick="return confirm(\'Are you sure you want to update?\')" href="?table=booking&id=' . $id . '&columnValue=2&column=status">Payment Confirmed</a></li>';
        }
else if ($status == 0) {
            $statusParam = "Payment Failed";
            $statusCSS = "badge bg-grd-danger";
             $value = '<li><a class="dropdown-item" onclick="return confirm(\'Are you sure you want to update?\')" href="?table=booking&id=' . $id . '&columnValue=2&column=status">Payment Confirmed</a></li>';
        }
        $room_name = $myName->showName($conn, "SELECT `name` FROM `rooms` WHERE `id`= '$room'");
        $location_id = $myName->showName($conn, "SELECT `location_id` FROM `rooms` WHERE `id`= '$room'");
        $location_name = $myName->showName($conn, "SELECT `name` FROM `location` WHERE `id`= '$location_id'");
        $total_amount = $myName->showName($conn, "SELECT `total_amount` FROM `transaction_details` WHERE `order_id`= '$order_code'");

        $check_in_date = new DateTime($check_in);
        $check_out_date = new DateTime($check_out);
        $interval = $check_in_date->diff($check_out_date);
        $days = $interval->days;

        $customer_name = $myName->showName($conn, "SELECT `name` FROM `customer` WHERE `account_number` = '$account_number'");

        echo '<tr>
            <td><a href="?value=' . $id . '"><strong>' . $customer_name . '</strong></a></td>
            <td><a href="?value=' . $id . '"><strong>' . $order_code . '</strong></a></td>
            <td><a href="?value=' . $id . '"><strong>' . $room_name . '</strong></a></td>
            <td>' . $location_name . '</td>
            <td>' . $check_in . '</td>
            <td>' . $check_out . '</td>
            <td>' . $days . '</td>
            <td>&#8358; ' . number_format(floatval($total_amount),2) . '</td>
            <td>' . $created_date . '</td>
            <td><span class="' . $statusCSS . '">' . $payment_type_value . '</span></td>
            <td><span class="' . $statusCSS . '">' . $statusParam . '</span></td>
             <td>
                <div class="btn-group">
                    <button class="btn btn-warning text-black dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">Options</button>
                    <ul class="dropdown-menu dropdown-block">
                        
                       '.$value.'
                        
                    </ul>
                </div>
            </td>
        </tr>';
    }
} else {
    echo '<tr><td colspan="10">No records found.</td></tr>';
}

$conn->close();
?>
