<?php

$emailing = "";
include("admin-includes/view-application-external.php");

// Handle form submission
if (isset($_POST['validate'])) {

    if (isset($_SESSION['email'])) {
        $emailing = $_SESSION['email'];
    }

    $status = '1';
    $datetime = date('Y-m-d H:i:s');
    $registeredby = $emailing;
 
    $amenities = $_POST['amenities']; // Array of amenities
    $icons = $_FILES['icon']; // Array of files (icons)

    // Define your custom maximum file size (in bytes)
    $maxFileSize = 2 * 1024 * 1024; // 2MB limit

    // Define the target directory
    $targetDir = "uploads/icons/";

    // Create the directory if it doesn't exist
    if (!is_dir($targetDir)) {
        mkdir($targetDir, 0777, true);
    }

    // Prepare the SQL statement
    $stmt = $conn->prepare("INSERT INTO room_amenities (`amenities`, `icon`, `status`, `created_at`) VALUES (?, ?, ?, ?)");

    // Loop through the arrays and insert each pair into the database
    for ($i = 0; $i < count($amenities); $i++) {
        $amenity = sanitize_input($conn, $amenities[$i]); // Sanitize each amenity
        $status = 1; // Assuming status is an integer with a value of 1

        // Handle file upload for the icon
        if (isset($icons['name'][$i]) && $icons['error'][$i] == 0) {
            // Check file size
            if ($icons['size'][$i] > $maxFileSize) {
                echo '<a href="#" class="btn btn-danger btn-lg">File too large: ' . htmlspecialchars($icons['name'][$i]) . ' exceeds the maximum size of ' . ($maxFileSize / 1024 / 1024) . 'MB.</a><br />';
                continue; // Skip this file and continue with the next iteration
            }

            // Generate a unique file name
            $fileName = basename($icons['name'][$i]);
            $targetFilePath = $targetDir . time() . "_" . $fileName;

            // Move the uploaded file to the target directory
            if (move_uploaded_file($icons['tmp_name'][$i], $targetFilePath)) {
                $iconPath = $targetFilePath; // Store the file path in the database
            } else {
                echo '<a href="#" class="btn btn-danger btn-lg">Failed to upload icon: ' . htmlspecialchars($icons['name'][$i]) . '.</a><br />';
                $iconPath = "uploads/icons/default.png"; // Use a default icon path
            }
        } else {
            // No file uploaded or there was an error
            if ($icons['error'][$i] != 0) {
                echo '<a href="#" class="btn btn-danger btn-lg">Error uploading file: ' . htmlspecialchars($icons['name'][$i]) . '.</a><br />';
            }
            $iconPath = "uploads/icons/default.png"; // Use a default icon path
        }

        // Bind parameters and execute the statement
        $stmt->bind_param("ssss", $amenity, $iconPath, $status, $datetime);
        if (!$stmt->execute()) {
            echo '<a href="#" class="btn btn-danger btn-lg">Failed to insert amenity: ' . htmlspecialchars($amenity) . '.</a><br />';
        }
    }

    // Check if the statement was successful
    if ($stmt->affected_rows > 0) {
         echo '<div class="alert alert-success border-0 bg-grd-success alert-dismissible fade show">
									<div class="d-flex align-items-center">
										<div class="font-35 text-white"><span class="material-icons-outlined fs-2">check_circle</span>
										</div>
										<div class="ms-3">
											<h6 class="mb-0 text-white">Success</h6>
											<div class="text-white">Information Submitted Successfully</div>
										</div>
									</div>
									<button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
								</div>';
    } else {
        echo '<a href="#" class="btn btn-danger btn-lg">Information Not Submitted Successfully. <br />Please try again later.</a><br />';
    }

    // Close the statement and connection
    $stmt->close();
    $conn->close();
}

// Function to sanitize inputs
function sanitize_input($conn, $data) {
    return mysqli_real_escape_string($conn, trim($data));
}

?>
