<?php
ini_set('display_startup_errors', 1);
ini_set('display_errors', 1);
error_reporting(-1);
include("app-config/DB_config.php");

// Handle form submission
if (isset($_POST['validate'])) {

    $location_id = sanitize_input($conn, $_POST['location']);
    $room_name = sanitize_input($conn, $_POST['name']);
    $room_cost = sanitize_input($conn, $_POST['cost']);
    $room_description = sanitize_input($conn, $_POST['content']);
    $adults = sanitize_input($conn, $_POST['adults']);
    $children = sanitize_input($conn, $_POST['children']);
    $datetime = date('Y-m-d H:i:s');

       
    // Directories for uploads
    $pictureDir = "uploads/pictures/";
    $videoDir = "uploads/videos/";

    // Create directories if they don't exist
    if (!is_dir($pictureDir)) {
        mkdir($pictureDir, 0777, true);
    }

    if (!is_dir($videoDir)) {
        mkdir($videoDir, 0777, true);
    }
    
    
    // Begin transaction
    $conn->begin_transaction();

    try {
        // Insert room details into the rooms table
        $stmt = $conn->prepare("INSERT INTO rooms (location_id, name, cost, description, adults, children, created_at) VALUES (?, ?, ?, ?, ?, ?, ?)");
        $stmt->bind_param("sssssss", $location_id, $room_name, $room_cost, $room_description, $adults, $children, $datetime);
        $stmt->execute();
        $room_id = $stmt->insert_id; // Get the last inserted room ID

        // Handle picture uploads
        $pictures = $_FILES['pictures'];
        if (!empty($pictures['name'][0])) {
            $targetDir = "uploads/pictures/";
            foreach ($pictures['name'] as $key => $value) {
                $fileName = basename($pictures['name'][$key]);
                $targetFilePath = $targetDir . time() . "_" . $fileName;

                if (move_uploaded_file($pictures['tmp_name'][$key], $targetFilePath)) {
                    $stmt = $conn->prepare("INSERT INTO room_pictures (room_id, picture_path, created_at) VALUES (?, ?, ?)");
                    $stmt->bind_param("sss", $room_id, $targetFilePath, $datetime);
                    $stmt->execute();
                }
            }
        }

        // Handle video uploads
  /*    $videos = $_FILES['video'];
if (!empty($videos['name'][0])) {
    $targetDir = "uploads/videos/";
    foreach ($videos['name'] as $key => $value) {
        if ($videos['error'][$key] == UPLOAD_ERR_OK) {
            $fileName = basename($videos['name'][$key]);
            $targetFilePath = $targetDir . time() . "_" . $fileName;

            if (move_uploaded_file($videos['tmp_name'][$key], $targetFilePath)) {
                $stmt = $conn->prepare("INSERT INTO room_videos (room_id, video_path, created_at) VALUES (?, ?, ?)");
                $stmt->bind_param("iss", $room_id, $targetFilePath, $datetime);
                $stmt->execute();
            } else {
                echo "Failed to move uploaded file: " . $videos['name'][$key];
            }
        } else {
            echo "Error uploading file: " . $videos['name'][$key] . " Error code: " . $videos['error'][$key];
        }
    }
}*/
$videos = $_FILES['video'];
if (!empty($videos['name'][0])) {
    $targetDir = "uploads/videos/";
    foreach ($videos['name'] as $key => $value) {
        if ($videos['error'][$key] == UPLOAD_ERR_OK) {
            $fileName = basename($videos['name'][$key]);
            $targetFilePath = $targetDir . time() . "_" . $fileName;

            if (move_uploaded_file($videos['tmp_name'][$key], $targetFilePath)) {
                $stmt = $conn->prepare("INSERT INTO room_videos (room_id, video_path, created_at) VALUES (?, ?, ?)");
                $stmt->bind_param("iss", $room_id, $targetFilePath, $datetime);
                $stmt->execute();
            } else {
                echo "<a href='#' class='btn btn-danger btn-lg'>Failed to move uploaded file: " . htmlspecialchars($videos['name'][$key])."</a><br />";;
            }
        } else {
            $errorMessages = [
                UPLOAD_ERR_INI_SIZE => 'The uploaded file exceeds the upload_max_filesize directive in php.ini.',
                UPLOAD_ERR_FORM_SIZE => 'The uploaded file exceeds the MAX_FILE_SIZE directive specified in the HTML form.',
                UPLOAD_ERR_PARTIAL => 'The uploaded file was only partially uploaded.',
                UPLOAD_ERR_NO_FILE => 'No file was uploaded.',
                UPLOAD_ERR_NO_TMP_DIR => 'Missing a temporary folder.',
                UPLOAD_ERR_CANT_WRITE => 'Failed to write file to disk.',
                UPLOAD_ERR_EXTENSION => 'A PHP extension stopped the file upload.'
            ];
            $error = $videos['error'][$key];
            echo "<a href='#' class='btn btn-danger btn-lg'>Error uploading file: " . htmlspecialchars($videos['name'][$key]) . " Error code: " . $errorMessages[$error]."</a><br />";
           
               
            
        }
    }
}


        // Handle amenities selection
        if (!empty($_POST['amenities'])) {
            foreach ($_POST['amenities'] as $amenity) {
                $stmt = $conn->prepare("INSERT INTO amenities (room_id, amenity_id, created_at) VALUES (?, ?, ?)");
                $stmt->bind_param("sss", $room_id, $amenity, $datetime);
                $stmt->execute();
            }
        }

        // Commit transaction
        $conn->commit();

         echo '<div class="alert alert-success border-0 bg-grd-success alert-dismissible fade show">
									<div class="d-flex align-items-center">
										<div class="font-35 text-white"><span class="material-icons-outlined fs-2">check_circle</span>
										</div>
										<div class="ms-3">
											<h6 class="mb-0 text-white">Success</h6>
											<div class="text-white">Information Submitted Successfully</div>
										</div>
									</div>
									<button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
								</div>';
    } catch (Exception $e) {
        // Rollback transaction on error
        $conn->rollback();
        error_log($e->getMessage());
        echo '<a href="#" class="btn btn-danger btn-lg">Information Not Submitted Successfully. <br />Please try again later.</a><br />';
    }

    // Close statement and connection
    $stmt->close();
    $conn->close();
}

// Function to sanitize inputs
function sanitize_input($conn, $data) {
    return mysqli_real_escape_string($conn, trim($data));
}

?>
