<?php

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;
use PHPMailer\PHPMailer\Exception;



// Load Composer's autoloader
require 'vendor/autoload.php';

function sendPaymentEmail($host, $email, $password, $port, $send_from_email, $send_from_name, $send_to_name, $send_to_email, $message, $subject) {
    $mail = new PHPMailer(true);
    try {
        // Server settings
        $mail->SMTPDebug = 0; // Set this to 0 to disable debugging output
        $mail->isSMTP();
        $mail->Host       = $host;
        $mail->SMTPAuth   = true;
        $mail->Username   = $email;
        $mail->Password   = $password;
        $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS;
        $mail->Port       = $port;

        // Recipients
        $mail->setFrom($send_from_email, $send_from_name);
        $mail->addAddress($send_to_email, $send_to_name);

        // Content
        $mail->isHTML(true);
        $mail->Subject = $subject;
        $mail->Body    = $message;
        $mail->AltBody = strip_tags($message);

        $mail->send();
        // echo 'Message has been sent';
    } catch (Exception $e) {
        // Handle the exception, e.g., log the error
        // echo "Message could not be sent. Mailer Error: {$mail->ErrorInfo}";
    }
}
?>
