<?php
ini_set('display_errors', '1');
ini_set('display_startup_errors', '1');
error_reporting(E_ALL);


require_once 'app-config/DB_config.php';
require_once 'admin-includes/SendingSMS.php';
require_once 'admin-includes/send-email.php';
require_once 'vendor/autoload.php';
include("admin-includes/view-application-external.php");
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;
use PHPMailer\PHPMailer\Exception;

 
// Build the base URL.
$protocol = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on') ? "https://" : "http://";
$baseUrl  = $protocol . $_SERVER['HTTP_HOST'];
 

// Query to fetch all members who haven't been sent a message yet.
$query = "SELECT * FROM jc_members WHERE issent = '0'";
$result = mysqli_query($conn, $query);

if (!$result) {
    die("Error retrieving members: " . mysqli_error($conn));
}

if (mysqli_num_rows($result) > 0) {
    while ($member = mysqli_fetch_assoc($result)) {
        // Retrieve member details.
        $id           = $member['id'];
        $surname      = $member['surname'];
        $first_name      = $member['first_name'];
        $phone_number = $member['phone_number'];
        $password     = $member['irrelivant']; // Consider renaming this column to something meaningful.
        $email_address = $member['email'] ?? ''; // Ensure the member record contains an email address if needed.
 

// Use the institution logo if set, otherwise use the placeholder image.
$logoUrl = isset($inst_logo1) ? $inst_logo1 : "https://placehold.co/110x110/png";

// Build the HTML table
$htmlTable = '
<table border="0" cellpadding="0" cellspacing="0" style="width:100%; max-width:600px; margin:20px auto; border-collapse:collapse; font-family: Arial, sans-serif; box-shadow: 0 2px 10px rgba(0,0,0,0.1);">
    <!-- Logo Row -->
    <tr style="background-color:#f8f8f8;">
        <td colspan="2" style="padding:20px; text-align:center;">
            <img src="' .  htmlspecialchars($logoUrl)  . '" alt="' . htmlspecialchars($inst_name1) . '" style="max-width:110px; max-height:110px;">
        </td>
    </tr>
    <!-- Header Row -->
    <tr style="background-color:#007BFF; color:#ffffff;">
        <th colspan="2" style="padding:15px; font-size:20px; text-transform:uppercase;">Hi,  ' . htmlspecialchars($surname) . ' ' . htmlspecialchars($first_name) . '</th>
    </tr>
    
    <tr style="background-color:#007BFF; color:#ffffff;">
        <th colspan="2" style="padding:15px; font-size:20px; text-transform:uppercase;">Welcome to ' . htmlspecialchars($inst_name1) . '</th>
    </tr>
    <!-- Username Row -->
    <tr>
        <td style="padding:15px; border:1px solid #ddd; font-weight:bold; background-color:#f2f2f2;">Username</td>
        <td style="padding:15px; border:1px solid #ddd;">' . htmlspecialchars($phone_number) . '</td>
    </tr>
    <!-- Password Row -->
    <tr>
        <td style="padding:15px; border:1px solid #ddd; font-weight:bold; background-color:#f2f2f2;">Password</td>
        <td style="padding:15px; border:1px solid #ddd;">' . htmlspecialchars($password) . '</td>
    </tr>
    <!-- Thank You Row -->
    
    <!-- App Access Row -->
    <tr>
        <td colspan="2" style="padding:15px; text-align:center; border:1px solid #ddd; background-color:#e9f7ef;">
            <strong>To open the App via a browser click:</strong> 
            <a href="https://rccgjesuscastleoyo4.org/self/" target="_blank" style="color:#007BFF; text-decoration:none;">https://rccgjesuscastleoyo4.org/self/</a>
        </td>
    </tr>
    <!-- App Install Row -->
    <tr>
        <td colspan="2" style="padding:15px; text-align:center; border:1px solid #ddd; background-color:#e9f7ef;">
            <strong>To install the App on your phone, click:</strong> 
            <a href="https://rccgjesuscastleoyo4.org/jc-members.apk" target="_blank" style="color:#007BFF; text-decoration:none;">https://rccgjesuscastleoyo4.org/jc-members.apk</a>
        </td>
    </tr>
    
    <tr>
        <td colspan="2" style="padding:15px; text-align:center; border:1px solid #ddd; background-color:#f8f8f8;">
            Thank you. ' . htmlspecialchars($inst_name1) . ' <em>(' . htmlspecialchars($inst_slogan1) . ')</em>
        </td>
    </tr>
</table>
';
 


// Output the table

 

        
        
        
        // Compose the welcome message.
        $message = "Welcome to $inst_name1\nUsername: $phone_number\nPassword: $password\nThank you.";

        // Send SMS using two different methods.
        //sendSMS($phone_number, "JC", $message);
     sendSms2($phone_number, $message);

        // Send a welcome email.
       sendEmail($conn, $surname, $email_address, $htmlTable);
      //sendEmail($conn, $surname, "olumideogundele@gmail.com", $htmlTable);

        // Update the member record to indicate the message has been sent.
     $updateQuery = "UPDATE jc_members SET issent = '1' WHERE id = '$id'";
        if (!mysqli_query($conn, $updateQuery)) {
            die("Error updating member (ID: $id): " . mysqli_error($conn));
        } 

        // Output the message (escaped for HTML) with newlines converted to breaks.
        echo nl2br(htmlspecialchars($message) . "\n\n");
        
        
        echo "<p> ".$email_address."    ".$htmlTable;
    }
}

/**
 * Sends an SMS using the configured SMS API.
 *
 * @param string $phone   The recipient's phone number.
 * @param string $sender  The sender name.
 * @param string $message The message content.
 */
function sendSMS($phone, $sender, $message) {
    global $conn;
    // Retrieve API credentials from the smsapi table.
    $apikey = (new Name)->showName($conn, "SELECT apikey FROM smsapi WHERE status = '1'");
    $email  = (new Name)->showName($conn, "SELECT email FROM smsapi WHERE status = '1'");

    $smsSender = new SendingSMS();
    $smsSender->smsAPI($phone, $sender, $message, $apikey, $email);
}

/**
 * Sends an SMS using BulkSMSNigeria API.
 *
 * @param string $to   The recipient's phone number.
 * @param string $body The SMS body content.
 *
 * @return mixed The API response.
 */
function sendSms2($to, $body) {
    $url = "https://www.bulksmsnigeria.com/api/v1/sms/create";
    $api_token = "Qao0XX14kGRYWN62Ar4NnQFepPMofHC5OFObsMsGYCA8ZDOuDn7hzaCmWGFT"; // Replace with your API token if needed.
    $from = "JESUSCASTLE";

    $postData = [
        'api_token' => $api_token,
        'from'      => $from,
        'to'        => $to,
        'body'      => $body
    ];

    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($postData));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    $response = curl_exec($ch);
    if ($response === false) {
        error_log("Failed to send SMS via BulkSMSNigeria: " . curl_error($ch));
    }
    curl_close($ch);

    return $response;
}

/**
 * Sends an email using the configured email API.
 *
 * @param mysqli $conn     The database connection.
 * @param string $fullname The recipient's full name.
 * @param string $email    The recipient's email address.
 * @param string $message  The email message content.
 */
function sendEmail($conn, $fullname, $email, $message) {
    // Retrieve email API configuration from the emailapi table.
    $host       = (new Name)->showName($conn, "SELECT name FROM emailapi WHERE status = '1'");
    $port       = (new Name)->showName($conn, "SELECT port FROM emailapi WHERE status = '1'");
    $password   = (new Name)->showName($conn, "SELECT password FROM emailapi WHERE status = '1'");
    $from_email = (new Name)->showName($conn, "SELECT email FROM emailapi WHERE status = '1'");

    // Use the global institution name.
    $inst_name1 = $GLOBALS['inst_name1'] ?? 'Institution';

    sendPaymentEmail(
        $host,
        $from_email,
        $password,
        $port,
        $from_email,
        $inst_name1,
        $fullname,
        $email,
        $message,
        "Welcome to " . $inst_name1
    );
}
?>
