 <?php
 
 // Initialize variables
$emailing = '';
$name = '';
$email = '';
$key = '';
$id = '';
$datetime = date('Y-m-d H:i:s'); // Use a consistent date format

if (isset($_POST['validate'])) {
    // Validate and sanitize input data
    $name = mysqli_real_escape_string($conn, $_POST['name']);
    $email = mysqli_real_escape_string($conn, $_POST['email']);
    $key = mysqli_real_escape_string($conn, $_POST['key']);
    $emailing = $_SESSION['email'] ?? ''; // Use null coalescing operator

    // Prepared statement to prevent SQL injection
    $stmt = $conn->prepare("INSERT INTO `smsapi`(`name`, `email`, `apikey`, `status`, `created_date`, `registeredby`) VALUES (?, ?, ?, '1', ?, ?)");
    $stmt->bind_param("sssss", $name, $email, $key, $datetime, $emailing);
    $process = $stmt->execute();

    // Handle errors and display messages
    if ($process) {
         echo '<div class="alert alert-success border-0 bg-grd-success alert-dismissible fade show">
									<div class="d-flex align-items-center">
										<div class="font-35 text-white"><span class="material-icons-outlined fs-2">check_circle</span>
										</div>
										<div class="ms-3">
											<h6 class="mb-0 text-white">Success</h6>
											<div class="text-white">Information Submitted Successfully</div>
										</div>
									</div>
									<button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
								</div>';
    } else {
        $error = "Not Inserted, Some Problem occured.";
        echo '<div class="btn btn-danger btn-lg">Information Not Submitted Successfully. <br />Please try again later.</div><br />';
    }
}

if (isset($_POST['update'])) {
    // Validate and sanitize input data
    $name = mysqli_real_escape_string($conn, $_POST['name']);
    $email = mysqli_real_escape_string($conn, $_POST['email']);
    $key = mysqli_real_escape_string($conn, $_POST['key']);
    $id = mysqli_real_escape_string($conn, $_POST['id']);
    $emailing = $_SESSION['email'] ?? ''; // Use null coalescing operator

    // Prepared statement to prevent SQL injection
    $stmt = $conn->prepare("UPDATE `smsapi` SET `name` = ?, `email` = ?, `apikey` = ?, `status` = '1' WHERE `id` = ?");
    $stmt->bind_param("ssss", $name, $email, $key, $id);
    $process = $stmt->execute();

    // Handle errors and display messages
    if ($process) {
        echo '<div class="btn btn-success btn-lg">Information Updated Successfully.</div><br />';
    } else {
        $error = "Not Inserted, Some Problem occured.";
        echo '<div class="btn btn-danger btn-lg">Information Not Updated Successfully. <br />Please try again later.</div><br />';
    }
}

$conn->close();
?>