<?php
include("app-config/DB_config.php"); 
include("admin-includes/SendingSMS.php");
include("admin-includes/send-email.php");

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;
use PHPMailer\PHPMailer\Exception;

require 'vendor/autoload.php';

$emailing = $_SESSION['email'] ?? '';

if (isset($_POST['validate'])) {
    // Determine the URL
    $url_1 = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https://" : "http://";
    $url_1 .= $_SERVER['HTTP_HOST'];

    // Retrieve and sanitize POST inputs
    $account_number = mysqli_real_escape_string($conn, $_POST['customer']);
    
    // Convert check-in and check-out dates to the required format (YYYY-MM-DD)
    $check_in = mysqli_real_escape_string($conn, $_POST['check-in']);
    $check_out = mysqli_real_escape_string($conn, $_POST['check-out']);
    $check_in = DateTime::createFromFormat('Y-m-d', $check_in)->format('Y-m-d');  // Formatting to YYYY-MM-DD
    $check_out = DateTime::createFromFormat('Y-m-d', $check_out)->format('Y-m-d'); // Formatting to YYYY-MM-DD
    
    $guests = mysqli_real_escape_string($conn, $_POST['guests']);
    $payment_type = mysqli_real_escape_string($conn, $_POST['payment_type']);
    $booking_type = mysqli_real_escape_string($conn, $_POST['boooking_type']);
    $payment_status = mysqli_real_escape_string($conn, $_POST['payment_status']);
    $special_note = isset($_POST['special_note']) ? mysqli_real_escape_string($conn, $_POST['special_note']) : '';
    
    // Use the current session for account details
    $registeredby = $_SESSION['account_number'];
    $fullname = (new Name)->showName($conn, "SELECT `name` FROM `customer` WHERE `account_number` = '$account_number'");
    $phone =  (new Name)->showName($conn, "SELECT `phone` FROM `customer` WHERE `account_number` = '$account_number'");

    // Process booking for the existing customer
    processBooking($conn, $url_1, $account_number, $fullname, $phone, $check_in, $check_out, $guests, $payment_type, $booking_type, $special_note);
}

function sendSMS($phone, $sender, $message) {
    global $conn;
    $apikey = (new Name)->showName($conn, "SELECT `apikey` FROM `smsapi` WHERE `status` = '1'");
    $email = (new Name)->showName($conn, "SELECT `email` FROM `smsapi` WHERE `status` = '1'");
    $Sending = new SendingSMS();
    $Sending->smsAPI($phone, $sender, $message, $apikey, $email);
}

function processBooking($conn, $url_1, $account_number, $fullname, $phone, $check_in, $check_out, $guests, $payment_type, $booking_type, $special_note) {
    $room_success = false;

    // Generate a single order ID to use for all rooms
    $order_id = substr($GLOBALS['inst_name1'], 1, 2) . "/" . rand(100000, 999999);
    $_SESSION['order_id'] = $order_id;

    if (isset($_POST['rooms'])) {
        foreach ($_POST['rooms'] as $room_id) {
            // Check if there's an existing booking with the same details
            $existing_order_code = (new Name)->showName($conn, "SELECT `order_code` FROM `booking` WHERE (`status` = '1' OR `status` = '2') AND `account_number` = '$account_number' AND `room` = '$room_id' AND `check_in` = '$check_in'");

            if (empty($existing_order_code)) {
                // Insert booking with the same order ID
$sql = "INSERT INTO `booking`(`order_code`, `account_number`, `check_in`, `check_out`, `guests`, `payment_type`, `room`, `boooking_type`, `created_date`, `registeredby`, `status`,`special_note`) 
                        VALUES ('$order_id', '$account_number', '$check_in', '$check_out', '$guests', '$payment_type', '$room_id', '$booking_type', '$GLOBALS[datetime]', '$account_number', '$payment_status', '$special_note')";
                $process = mysqli_query($conn, $sql) or die(mysqli_error($conn));
                
                

                       
                
                
                
                if ($process) {
                    $room_success = true;
                    $link = $url_1 . '/self';
                    $message = "Hi $fullname\nYour order is accepted.\nOrder Code: $order_id\nTo log into your account, $link\nThank you for choosing us.";
                    sendSMS($phone, "APP", $message);
                }
            }
        }
    }

    if ($room_success) {
        echo '<div class="btn btn-success btn-lg">Room order successful. Please wait..</div><br />';
        echo '<meta http-equiv="Refresh" content="5; url=booking-processed">';
    } else {
        echo '<div class="btn btn-danger btn-lg">Room order not successful. Please try again later.</div><br />';
    }
}
?>
