<?php
include("app-config/DB_config.php");
  $pictureDir = "uploads/testimonial/";
  

    // Create directories if they don't exist
    if (!is_dir($pictureDir)) {
        mkdir($pictureDir, 0777, true);
    }

// Function to handle file upload
function uploadFile($file) {
    $target_dir = "uploads/testimonial/";
    $file_name = basename($file["name"]);
    $target_file = $target_dir . time() . "_" . $file_name;
    $uploadOk = 1;
    $imageFileType = strtolower(pathinfo($target_file, PATHINFO_EXTENSION));

    // Check if file is an image
    $check = getimagesize($file["tmp_name"]);
    if ($check !== false) {
        $uploadOk = 1;
    } else {
        $uploadOk = 0;
    }

    // Check file size (5MB limit)
    if ($file["size"] > 5000000) {
        $uploadOk = 0;
    }

    // Allow certain file formats
    if ($imageFileType != "jpg" && $imageFileType != "png" && $imageFileType != "jpeg"
        && $imageFileType != "gif") {
        $uploadOk = 0;
    }

    // Check if $uploadOk is set to 0 by an error
    if ($uploadOk == 0) {
        return false;
    } else {
        if (move_uploaded_file($file["tmp_name"], $target_file)) {
            return $target_file;
        } else {
            return false;
        }
    }
}

// Check if form is submitted
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $name = mysqli_real_escape_string($conn, $_POST['name']);
    $position = mysqli_real_escape_string($conn, $_POST['position']);
    $testimony = mysqli_real_escape_string($conn, $_POST['content']);
    $picture_path = '';

    // Handle file upload
    if (isset($_FILES["pictures"])) {
        $picture_path = uploadFile($_FILES["pictures"]);
        if (!$picture_path) {
            echo "<div class='btn btn-dangers btn-lg'>Sorry, there was an error uploading your file.</div>";
            exit;
        }
    }

    if (isset($_GET['value'])) {
        // Update existing record
        $id = mysqli_real_escape_string($conn, $_GET['value']);
        $query = "UPDATE `testimony` SET 
                    `name` = '$name', 
                    `position` = '$position', 
                    `testimony` = '$testimony', 
                    `picture_path` = '$picture_path',
                    `updated_at` = NOW()
                  WHERE `id` = '$id'";
    } else {
        // Insert new record
        $query = "INSERT INTO `testimony` (`name`, `position`, `testimony`, `picture_path`) 
                  VALUES ('$name', '$position', '$testimony', '$picture_path')";
    }

    if (mysqli_query($conn, $query)) {
        echo "<div class='btn btn-success btn-lg'>Record saved successfully.</div>";
    } else {
        echo "<div class='btn btn-dangers btn-lg'>Error: " . mysqli_error($conn). "</div><br>";
    }
}
?>

<!-- Quill Editor Initialization -->
<script>
    var quill = new Quill('#editor-container', {
        theme: 'snow'
    });

    // Sync hidden textarea with Quill content on form submit
    document.querySelector('form').onsubmit = function() {
        document.querySelector('textarea[name=content]').value = quill.root.innerHTML;
    };
</script>
