<?php
//include("app-config/DB_config.php");

function getValue($conn) {
    $query = "SELECT `id`, `short_description`, `full_description`, `picture_path`, `registeredby`, `created_at`, `status` FROM `about_us` WHERE status = 1 ORDER BY `id` DESC LIMIT 1";
    $stmt = $conn->prepare($query);
    $stmt->execute();
    $result = $stmt->get_result();
    return $result;
}

// Fetch pouchi setup data
$pouchiSetups = getValue($conn);
$count = $pouchiSetups->num_rows;

if ($count > 0) {
    while ($row = $pouchiSetups->fetch_assoc()) {
        $id = htmlspecialchars($row['id']);
        $short_description = $row['short_description'];
        $full_description = $row['full_description'];
        $picture_path = $row['picture_path'];
        $registeredby = htmlspecialchars($row['registeredby']);
        $created_at = htmlspecialchars($row['created_at']);
        $status = htmlspecialchars($row['status']);

        $statusCSS = $status == 1 ? "badge bg-grd-success" : "badge bg-grd-danger";
        $statusParam = $status == 1 ? "Active" : "Not Active";

        
       // echo $picture_path;
        // Convert the JSON-like string into an array
        $pictureArray = json_decode($picture_path, true);

        // Check if decoding was successful and there are elements in the array
        if (is_array($pictureArray) && count($pictureArray) > 0) {
            $first_picture = $pictureArray[0]; // First element
            $last_picture = $pictureArray[count($pictureArray) - 1]; // Last element
        } else {
            $first_picture = "default_first_image.jpg"; // Fallback if decoding fails or array is empty
            $last_picture = "default_last_image.jpg";  // Fallback if decoding fails or array is empty
        }

        // Now you can use $first_picture and $last_picture as needed
        //echo "First Picture: " . $first_picture . "<br>";
       // echo "Last Picture: " . $last_picture . "<br>";
    }
} else {
    echo '<tr><td colspan="13">No records found.</td></tr>';
}
?>
