<?php
include("app-config/DB_config.php");
$myName = new Name();

 
$emailing = isset($_SESSION['email']) ? $_SESSION['email'] : '';

// Function to get application data securely
function getApplicationData($conn) {
    $query = "SELECT `id`, `name`, `logo`, `phone`, `email`, `slogan`, `address`, `status`, `created_date`, `registeredby` FROM `application`";
    $stmt = $conn->prepare($query);
    $stmt->execute();
    $result = $stmt->get_result();
    return $result;
}

// Fetch application data
$applications = getApplicationData($conn);
$count = $applications->num_rows;

if ($count > 0) {
    while ($row = $applications->fetch_assoc()) {
        $id = htmlspecialchars($row['id']);
        $name = htmlspecialchars($row['name']);
        $logo = htmlspecialchars($row['logo']);
        $phone = htmlspecialchars($row['phone']);
        $email = htmlspecialchars($row['email']);
        $slogan = htmlspecialchars($row['slogan']);
        $address = htmlspecialchars($row['address']);
        $status = htmlspecialchars($row['status']);
        $created_date = htmlspecialchars($row['created_date']);
        $registeredby = htmlspecialchars($row['registeredby']);

        $statusCSS = $status == 1 ? "badge bg-grd-success" : "badge bg-grd-danger";
        $statusParam = $status == 1 ? "Active" : "Not Active";

        echo '<tr>
            <td><a href="?value=' . $id . '"> <strong>' . $name . '</strong> </a></td>
            <td>' . $slogan . '</td>
            <td>' . $phone . '</td>
            <td>' . $email . '</td>
            <td>' . $address . '</td>
            <td>' . $created_date . '</td>
            <td>' . $registeredby . '</td>
            <td> <span class="' . $statusCSS . '">' . $statusParam . ' </span> </td>
            <td>
                <div class="btn-group">
                    <button class="btn btn-warning text-black dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">Options</button>
                    <ul class="dropdown-menu dropdown-block">
                        <li><a class="dropdown-item" onclick="return confirm(\'Are you sure you want to delete?\')" href="?table=application&del=' . $id . '">Delete</a></li>
                        <li><a class="dropdown-item" onclick="return confirm(\'Are you sure you want to update?\')" href="?table=application&id=' . $id . '&columnValue=1&column=status">Activate</a></li>
                        <li><a class="dropdown-item" onclick="return confirm(\'Are you sure you want to update?\')" href="?table=application&id=' . $id . '&columnValue=0&column=status">Deactivate</a></li>
                    </ul>
                </div>
            </td>
        </tr>';
    }
} else {
    echo '<tr><td colspan="9">No records found.</td></tr>';
}
?>
