<?php
include("app-config/DB_config.php");
$myName = new Name();

$emailing = isset($_SESSION['email']) ? $_SESSION['email'] : '';

 //SELECT `id`, `description`, `banner_value`, `icon`, `status`, `created_at` FROM `banner` WHERE 1

function getPouchiSetupData($conn) {
    $query = "SELECT  `id`, `description`, `banner_value`, `icon`, `status`, `created_at`  FROM `banner`";
    $stmt = $conn->prepare($query);
    $stmt->execute();
    $result = $stmt->get_result();
    return $result;
}

// Fetch pouchi setup data
$pouchiSetups = getPouchiSetupData($conn);
$count = $pouchiSetups->num_rows;

if ($count > 0) {
    while ($row = $pouchiSetups->fetch_assoc()) {
        $id = htmlspecialchars($row['id']);
      
        $description = htmlspecialchars($row['description']);
        $banner_value = htmlspecialchars($row['banner_value']);
        $icon = htmlspecialchars($row['icon']);
        $status = htmlspecialchars($row['status']);
        $created_at = htmlspecialchars($row['created_at']);
    

        $statusCSS = $status == 1 ? "badge bg-grd-success" : "badge bg-grd-danger";
        $statusParam = $status == 1 ? "Active" : "Not Active";

        echo '<tr>
         
            <td><a href="?value=' . $id . '"> <strong>' . $description. '</strong> </a></td>
            <td><a href="?value=' . $id . '"> <strong>' . $banner_value. '</strong> </a></td>
           
             <td>' . $created_at . '</td>
         
            <td> <span class="' . $statusCSS . '">' . $statusParam . ' </span> </td>
            <td>
                <div class="btn-group">
                    <button class="btn btn-warning text-black dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">Options</button>
                    <ul class="dropdown-menu dropdown-block">
                        <li><a class="dropdown-item" onclick="return confirm(\'Are you sure you want to delete?\')" href="?table=banner&del=' . $id . '">Delete</a></li>
                        <li><a class="dropdown-item" onclick="return confirm(\'Are you sure you want to update?\')" href="?table=banner&id=' . $id . '&columnValue=1&column=status">Activate</a></li>
                        <li><a class="dropdown-item" onclick="return confirm(\'Are you sure you want to update?\')" href="?table=banner&id=' . $id . '&columnValue=0&column=status">Deactivate</a></li>
                    </ul>
                </div>
            </td>
        </tr>';
    }
} else {
    echo '<tr><td colspan="13">No records found.</td></tr>';
}

$conn->close();
?>
