<?php
include("../pl/app-config/DB_config.php");
$myName = new Name();

$emailing = isset($_SESSION['account_number']) ? $_SESSION['account_number'] : '';
$query = '';

if (isset($_GET['status'])) {
    $status = base64_decode(strtr($_GET['status'], '-_,', '+/='));
    $query = "SELECT `id`, `order_code`, `account_number`, `check_in`, `check_out`, `guests`, `payment_type`, `room`, `boooking_type`, `created_date`, `registeredby`, `status`, `special_note` 
              FROM `booking` 
              WHERE `account_number` = '$emailing' AND `status` = '$status' ORDER BY `id` DESC LIMIT 10";
} else {
    $query = "SELECT `id`, `order_code`, `account_number`, `check_in`, `check_out`, `guests`, `payment_type`, `room`, `boooking_type`, `created_date`, `registeredby`, `status`, `special_note` 
              FROM `booking` 
              WHERE `account_number` = '$emailing'  ORDER BY `id` DESC LIMIT 10";
}

 

function getReport($conn, $query) {
    $stmt = $conn->prepare($query);
    $stmt->execute();
    $result = $stmt->get_result();
    return $result;
}

// Fetch booking data
$pouchiSetups = getReport($conn, $query);
$count = $pouchiSetups->num_rows;

if ($count > 0) {
    while ($row = $pouchiSetups->fetch_assoc()) {
        $id = htmlspecialchars($row['id']);
        $order_code = htmlspecialchars($row['order_code']);
        $account_number = htmlspecialchars($row['account_number']);
        $check_in = htmlspecialchars($row['check_in']);
        $check_out = htmlspecialchars($row['check_out']);
        $guests = htmlspecialchars($row['guests']);
        $payment_type = htmlspecialchars($row['payment_type']);
        $room = htmlspecialchars($row['room']);
        $boooking_type = htmlspecialchars($row['boooking_type']);
        $created_date = htmlspecialchars($row['created_date']);
        $registeredby = htmlspecialchars($row['registeredby']);
        $status = htmlspecialchars($row['status']);
        $special_note = htmlspecialchars($row['special_note']);

        // Determine payment type label
        $payment_type_value = "";
        if ($payment_type == 1) {
            $payment_type_value = "Cash";
        } else if ($payment_type == 2) {
            $payment_type_value = "Transfer";
        } else if ($payment_type == 3) {
            $payment_type_value = "Online Payment";
        }

        // Determine booking status CSS class and label
        $statusCSS = "";
        $statusParam = "";
        if ($status == 1) {
            $statusParam = "Active";
            $statusCSS = "badge bg-grd-warning";
        } else if ($status == 2) {
            $statusParam = "Paid";
            $statusCSS = "badge bg-grd-success";
        } else if ($status == 3) {
            $statusParam = "Checked  In";
            $statusCSS = "badge bg-grd-success";
        } else if ($status == 4) {
            $statusParam = "Over Stayed";
            $statusCSS = "badge bg-grd-danger";
        } else if ($status == 5) {
            $statusParam = "Checked  Out";
            $statusCSS = "badge bg-grd-success";
        } else if ($status == 6) {
            $statusParam = "Payment Failed";
            $statusCSS = "badge bg-grd-danger";
        }

        $room_name = $myName->showName($conn, "SELECT `name` FROM `rooms` WHERE `id`= '$room'");
        $location_id = $myName->showName($conn, "SELECT `location_id` FROM `rooms` WHERE `id`= '$room'");
        $location_name = $myName->showName($conn, "SELECT `name` FROM `location` WHERE `id`= '$location_id'");
        $total_amount = $myName->showName($conn, "SELECT `total_amount` FROM `transaction_details` WHERE `order_id`= '$order_code'");

        $check_in_date = new DateTime($check_in);
        $check_out_date = new DateTime($check_out);
        $interval = $check_in_date->diff($check_out_date);
        $days = $interval->days;

        $update_phone = $myName->showName($conn, "SELECT `phone` FROM `user_unit` WHERE `account_number` = '$account_number'");
        
      
        
        echo '<tr>
                            <td>
                              <div class="d-flex align-items-center gap-3">
                                 <div class="">
                                    <img src="../pl/'.$inst_logo1.'" class="rounded-circle" width="50" height="50" alt="">
                                 </div>
                                 <p class="mb-0">' . $order_code . '</p>
                              </div>
                            </td>
  <td><a href="?value=' . $id . '"><strong>' . $room_name . '</strong></a></td>
            <td>' . $location_name . '</td>
            <td>' . $check_in . '</td>
            <td>' . $check_out . '</td>
            <td>' . $days . '</td>
            <td>' . $total_amount . '</td>
            <td>' . $created_date . '</td>
            <td><span class="' . $statusCSS . '">' . $payment_type_value . '</span></td>
            <td><span class="' . $statusCSS . '">' . $statusParam . '</span></td>
                          </tr>';
        
        
 
    }
} else {
    echo '<tr><td colspan="10">No records found.</td></tr>';
}

$conn->close();
?>
