<?php
include("pl/app-config/DB_config.php");
$myName = new Name();

$emailing = isset($_SESSION['email']) ? $_SESSION['email'] : '';

 
function getPouchiSetupData($conn) {
    $query = "SELECT `id`, `short_description`, `full_description` , `registeredby`, `created_at`,`status` FROM `faq`";
    $stmt = $conn->prepare($query);
    $stmt->execute();
    $result = $stmt->get_result();
    return $result;
}

// Fetch pouchi setup data
$pouchiSetups = getPouchiSetupData($conn);
$count = $pouchiSetups->num_rows;

if ($count > 0) {
    while ($row = $pouchiSetups->fetch_assoc()) {
        $id = htmlspecialchars($row['id']);
        $short_description = htmlspecialchars($row['short_description']);
        $full_description = htmlspecialchars($row['full_description']);
       $registeredby = htmlspecialchars($row['registeredby']);
        $created_at = htmlspecialchars($row['created_at']);
        $status = htmlspecialchars($row['status']);
       

        $statusCSS = $status == 1 ? "badge bg-grd-success" : "badge bg-grd-danger";
        $statusParam = $status == 1 ? "Active" : "Not Active";

        echo '<div class="col-12">
                  <div class="accordion__item accordion__item--style2" data-aos="fade-up-left" data-aos-duration="1000">
                    <div class="accordion__header" id="faq'.$id.'a">
                      <button class="accordion__button collapsed" type="button" data-bs-toggle="collapse"
                        data-bs-target="#faqBody'.$id.'a" aria-expanded="false" aria-controls="faqBody'.$id.'a">
                      '. $short_description.'
                        <span class="plus-icon"></span>
                      </button>
                    </div>
                    <div id="faqBody'.$id.'a" class="accordion-collapse collapse" aria-labelledby="faq'.$id.'a"
                      data-bs-parent="#faqAccordion2">
                      <div class="accordion__body">
                       '.$full_description.'
                      </div>
                    </div>
                  </div>
                </div>';
    }
} else {
      echo '<div class="col-12">
                  <div class="accordion__item accordion__item--style2" data-aos="fade-up-left" data-aos-duration="1000">
                    <div class="accordion__header" id="faq'.$id.'a">
                      <button class="accordion__button collapsed" type="button" data-bs-toggle="collapse"
                        data-bs-target="#faqBody'.$id.'a" aria-expanded="false" aria-controls="faqBody'.$id.'a">
                     No Information Available Yet
                        <span class="plus-icon"></span>
                      </button>
                    </div>
                    <div id="faqBody'.$id.'a" class="accordion-collapse collapse" aria-labelledby="faq'.$id.'a"
                      data-bs-parent="#faqAccordion2">
                      <div class="accordion__body">
                       No Information Available Yet. Please check back soon.
                      </div>
                    </div>
                  </div>
                </div>';
}

$conn->close();
?>
