<?php
include("app-config/DB_config.php");
$myName = new Name();

$emailing = isset($_SESSION['email']) ? $_SESSION['email'] : '';

 
function getPouchiSetupData($conn) {
    $query = "SELECT `id`, `short_description`, `full_description` , `registeredby`, `created_at`,`status` FROM `faq`";
    $stmt = $conn->prepare($query);
    $stmt->execute();
    $result = $stmt->get_result();
    return $result;
}

// Fetch pouchi setup data
$pouchiSetups = getPouchiSetupData($conn);
$count = $pouchiSetups->num_rows;

if ($count > 0) {
    while ($row = $pouchiSetups->fetch_assoc()) {
        $id = htmlspecialchars($row['id']);
        $short_description = htmlspecialchars($row['short_description']);
        $full_description = htmlspecialchars($row['full_description']);
       $registeredby = htmlspecialchars($row['registeredby']);
        $created_at = htmlspecialchars($row['created_at']);
        $status = htmlspecialchars($row['status']);
       

        $statusCSS = $status == 1 ? "badge bg-grd-success" : "badge bg-grd-danger";
        $statusParam = $status == 1 ? "Active" : "Not Active";

        echo '<tr>
            <td><a href="about-setup?value=' . $id . '"> <strong>' . $short_description . '</strong> </a></td>
             <td>' . $created_at . '</td>
            <td> <span class="' . $statusCSS . '">' . $statusParam . ' </span> </td>
            <td>
                <div class="btn-group">
                    <button class="btn btn-warning text-black dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">Options</button>
                    <ul class="dropdown-menu dropdown-block">
                        <li><a class="dropdown-item" onclick="return confirm(\'Are you sure you want to delete?\')" href="?table=faq&del=' . $id . '">Delete</a></li>
                        <li><a class="dropdown-item" onclick="return confirm(\'Are you sure you want to update?\')" href="?table=faq&id=' . $id . '&columnValue=1&column=status">Activate</a></li>
                        <li><a class="dropdown-item" onclick="return confirm(\'Are you sure you want to update?\')" href="?table=faq&id=' . $id . '&columnValue=0&column=status">Deactivate</a></li>
                    </ul>
                </div>
            </td>
        </tr>';
    }
} else {
    echo '<tr><td colspan="13">No records found.</td></tr>';
}

$conn->close();
?>
