<?php
include("app-config/DB_config.php");
$myName = new Name();

$emailing = isset($_SESSION['email']) ? $_SESSION['email'] : '';

// Function to get pouchi setup data securely
//SELECT `id`, `publickey`, `secretkey`, `encryptionkey`, `created_date`, `registeredby`, `url` FROM `flutterwave` WHERE 1


function getPouchiSetupData($conn) {
    $query = "SELECT `id`, `publickey`, `secretkey`, `encryptionkey`, `created_date`, `registeredby`, `url`, `status` FROM `flutterwave`";
    $stmt = $conn->prepare($query);
    $stmt->execute();
    $result = $stmt->get_result();
    return $result;
}

// Fetch pouchi setup data
$pouchiSetups = getPouchiSetupData($conn);
$count = $pouchiSetups->num_rows;

if ($count > 0) {
    while ($row = $pouchiSetups->fetch_assoc()) {
        $id = htmlspecialchars($row['id']);
        $publickey = htmlspecialchars($row['publickey']);
        $secretkey = htmlspecialchars($row['secretkey']);
        $encryptionkey = htmlspecialchars($row['encryptionkey']);
        $created_date = htmlspecialchars($row['created_date']);
        $registeredby = htmlspecialchars($row['registeredby']);
        $url = htmlspecialchars($row['url']);
        $status = htmlspecialchars($row['status']);
    

        $statusCSS = $status == 1 ? "badge bg-grd-success" : "badge bg-grd-danger";
        $statusParam = $status == 1 ? "Active" : "Not Active";

        echo '<tr>
            <td><a href="?value=' . $id . '"> <strong>' . $publickey . '</strong> </a></td>
            <td>' . $secretkey . '</td>
            <td>' . $encryptionkey . '</td>
             <td>' . $created_date . '</td>
            <td>' . $registeredby . '</td>
            <td> <span class="' . $statusCSS . '">' . $statusParam . ' </span> </td>
            <td>
                <div class="btn-group">
                    <button class="btn btn-warning text-black dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">Options</button>
                    <ul class="dropdown-menu dropdown-block">
                        <li><a class="dropdown-item" onclick="return confirm(\'Are you sure you want to delete?\')" href="?table=flutterwave&del=' . $id . '">Delete</a></li>
                        <li><a class="dropdown-item" onclick="return confirm(\'Are you sure you want to update?\')" href="?table=flutterwave&id=' . $id . '&columnValue=1&column=status">Activate</a></li>
                        <li><a class="dropdown-item" onclick="return confirm(\'Are you sure you want to update?\')" href="?table=flutterwave&id=' . $id . '&columnValue=0&column=status">Deactivate</a></li>
                    </ul>
                </div>
            </td>
        </tr>';
    }
} else {
    echo '<tr><td colspan="13">No records found.</td></tr>';
}

$conn->close();
?>
