<?php
include("app-config/DB_config.php");
$myName = new Name();

$emailing = isset($_SESSION['email']) ? $_SESSION['email'] : '';

 

function getPouchiSetupData($conn) {
    $query = "SELECT `id`, `location_id`, `amenities`, `status`, `created_at` FROM `location_amenities`";
    $stmt = $conn->prepare($query);
    $stmt->execute();
    $result = $stmt->get_result();
    return $result;
}

// Fetch pouchi setup data
$pouchiSetups = getPouchiSetupData($conn);
$count = $pouchiSetups->num_rows;

if ($count > 0) {
    while ($row = $pouchiSetups->fetch_assoc()) {
        $id = htmlspecialchars($row['id']);
        $location_id = htmlspecialchars($row['location_id']);
        $amenities = htmlspecialchars($row['amenities']);
        $status = htmlspecialchars($row['status']);
        $created_at = htmlspecialchars($row['created_at']);
    $location_name = $myName->showName($conn, "SELECT `name` FROM `location` WHERE  `id` = '$location_id'");

        $statusCSS = $status == 1 ? "badge bg-grd-success" : "badge bg-grd-danger";
        $statusParam = $status == 1 ? "Active" : "Not Active";

        echo '<tr>
            <td><a href="?value=' . $id . '"> <strong>' . $location_name . '</strong> </a></td>
            <td>' . $amenities. '</td>
           
             <td>' . $created_at . '</td>
         
            <td> <span class="' . $statusCSS . '">' . $statusParam . ' </span> </td>
            <td>
                <div class="btn-group">
                    <button class="btn btn-warning text-black dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">Options</button>
                    <ul class="dropdown-menu dropdown-block">
                        <li><a class="dropdown-item" onclick="return confirm(\'Are you sure you want to delete?\')" href="?table=location_amenities&del=' . $id . '">Delete</a></li>
                        <li><a class="dropdown-item" onclick="return confirm(\'Are you sure you want to update?\')" href="?table=location_amenities&id=' . $id . '&columnValue=1&column=status">Activate</a></li>
                        <li><a class="dropdown-item" onclick="return confirm(\'Are you sure you want to update?\')" href="?table=location_amenities&id=' . $id . '&columnValue=0&column=status">Deactivate</a></li>
                    </ul>
                </div>
            </td>
        </tr>';
    }
} else {
    echo '<tr><td colspan="13">No records found.</td></tr>';
}

$conn->close();
?>
