<?php
include("app-config/DB_config.php");
$myName = new Name();

$emailing = isset($_SESSION['email']) ? $_SESSION['email'] : '';

 

function getPouchiSetupData($conn) {
    $query = "SELECT `id`, `name`, `address`, `longi`, `lati`, `pastor`, `created_at`, `registeredby`, `status`, `logo`, zone_id , area_id FROM `parishes`";
    $stmt = $conn->prepare($query);
    $stmt->execute();
    $result = $stmt->get_result();
    return $result;
}

// Fetch pouchi setup data
$pouchiSetups = getPouchiSetupData($conn);
$count = $pouchiSetups->num_rows;

if ($count > 0) {
    while ($row = $pouchiSetups->fetch_assoc()) {
        $id = htmlspecialchars($row['id']);
        $name = htmlspecialchars($row['name']);
        $address = htmlspecialchars($row['address']);
        $longi = htmlspecialchars($row['longi']);
        $lati = htmlspecialchars($row['lati']);
        $leader = htmlspecialchars($row['pastor']);
        $created_at = htmlspecialchars($row['created_at']);
        $registeredby = htmlspecialchars($row['registeredby']);
        $status = htmlspecialchars($row['status']);
        $logo = htmlspecialchars($row['logo']);
        $zone_id = htmlspecialchars($row['zone_id']);
        $area_id = htmlspecialchars($row['area_id']);
      

        $statusCSS = $status == 1 ? "badge bg-grd-success" : "badge bg-grd-danger";
        $statusParam = $status == 1 ? "Active" : "Not Active";
        
        
         $surname = $myName->showName($conn, "SELECT `surname`  FROM `pastors` WHERE `id` = '$leader'"); 
         $first_name = $myName->showName($conn, "SELECT `first_name`  FROM `pastors` WHERE `id` = '$leader'"); 
        
        $fullname = $surname .' '.$first_name;
        
        
 $zone_name = $myName->showName($conn, "SELECT `name` FROM `zones` WHERE `id` = '$zone_id'");
 $area_name = $myName->showName($conn, "SELECT `name` FROM `areas` WHERE `id` = '$area_id'");
        
        
        
        
        echo '<tr>
            <td><a href="?value=' . $id . '"> <strong>' . $zone_name . '</strong> </a></td> 
            <td><a href="?value=' . $id . '"> <strong>' . $area_name . '</strong> </a></td> 

<td><a href="?value=' . $id . '"> <img src = "'.$logo.'" width = "40px"><br>
<strong>' . $name . '</strong> </a></td>
            <td>' . $address . '</td>
            <td>' . $fullname . '</td>
           
             <td>' . $created_at . '</td>
            <td>' . $registeredby . '</td>
            <td> <span class="' . $statusCSS . '">' . $statusParam . ' </span> </td>
            <td>
                <div class="btn-group">
                    <button class="btn btn-warning text-black dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">Options</button>
                    <ul class="dropdown-menu dropdown-block">
                        <li><a class="dropdown-item" onclick="return confirm(\'Are you sure you want to delete?\')" href="?table=parishes&del=' . $id . '">Delete</a></li>
                        <li><a class="dropdown-item" onclick="return confirm(\'Are you sure you want to update?\')" href="?table=parishes&id=' . $id . '&columnValue=1&column=status">Activate</a></li>
                        <li><a class="dropdown-item" onclick="return confirm(\'Are you sure you want to update?\')" href="?table=parishes&id=' . $id . '&columnValue=0&column=status">Deactivate</a></li>
                    </ul>
                </div>
            </td>
        </tr>';
    }
} else {
    echo '<tr><td colspan="13">No records found.</td></tr>';
}

$conn->close();
?>
