<?php
include("app-config/DB_config.php");
$myName = new Name();

$emailing = isset($_SESSION['email']) ? $_SESSION['email'] : '';

// Function to get pouchi setup data securely
function getPouchiSetupData($conn) {
    $query = "SELECT `id`, `requestChannelId`, `requestChannel`, `requestChannelType`, `requestApplicationCode`, `requestApplicationModule`, `requestPartnerCode`, `username`, `password`, `rememberMe`, `status`, `created_date`, `registeredby` FROM `pouchi_setup`";
    $stmt = $conn->prepare($query);
    $stmt->execute();
    $result = $stmt->get_result();
    return $result;
}

// Fetch pouchi setup data
$pouchiSetups = getPouchiSetupData($conn);
$count = $pouchiSetups->num_rows;

if ($count > 0) {
    while ($row = $pouchiSetups->fetch_assoc()) {
        $id = htmlspecialchars($row['id']);
        $requestChannelId = htmlspecialchars($row['requestChannelId']);
        $requestChannel = htmlspecialchars($row['requestChannel']);
        $requestChannelType = htmlspecialchars($row['requestChannelType']);
        $requestApplicationCode = htmlspecialchars($row['requestApplicationCode']);
        $requestApplicationModule = htmlspecialchars($row['requestApplicationModule']);
        $requestPartnerCode = htmlspecialchars($row['requestPartnerCode']);
        $username = htmlspecialchars($row['username']);
        $password = htmlspecialchars($row['password']);
        $rememberMe = htmlspecialchars($row['rememberMe']);
        $status = htmlspecialchars($row['status']);
        $created_date = htmlspecialchars($row['created_date']);
        $registeredby = htmlspecialchars($row['registeredby']);

        $statusCSS = $status == 1 ? "badge bg-grd-success" : "badge bg-grd-danger";
        $statusParam = $status == 1 ? "Active" : "Not Active";

        echo '<tr>
            <td><a href="?value=' . $id . '"> <strong>' . $requestChannel . '</strong> </a></td>
            <td>' . $requestChannelId . '</td>
            <td>' . $requestChannelType . '</td>
            <td>' . $requestApplicationCode . '</td>
            <td>' . $requestApplicationModule . '</td>
            <td>' . $requestPartnerCode . '</td>
            <td>' . $username . '</td>
            <td>' . $password . '</td>
            <td>' . $rememberMe . '</td>
            <td>' . $created_date . '</td>
            <td>' . $registeredby . '</td>
            <td> <span class="' . $statusCSS . '">' . $statusParam . ' </span> </td>
            <td>
                <div class="btn-group">
                    <button class="btn btn-warning text-black dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">Options</button>
                    <ul class="dropdown-menu dropdown-block">
                        <li><a class="dropdown-item" onclick="return confirm(\'Are you sure you want to delete?\')" href="?table=pouchi_setup&del=' . $id . '">Delete</a></li>
                        <li><a class="dropdown-item" onclick="return confirm(\'Are you sure you want to update?\')" href="?table=pouchi_setup&id=' . $id . '&columnValue=1&column=status">Activate</a></li>
                        <li><a class="dropdown-item" onclick="return confirm(\'Are you sure you want to update?\')" href="?table=pouchi_setup&id=' . $id . '&columnValue=0&column=status">Deactivate</a></li>
                    </ul>
                </div>
            </td>
        </tr>';
    }
} else {
    echo '<tr><td colspan="13">No records found.</td></tr>';
}

$conn->close();
?>
