<?php
include("app-config/DB_config.php");
$myName = new Name();

$emailing = isset($_SESSION['email']) ? $_SESSION['email'] : '';

 //`id`, `location_id`, `name`, `cost`, `description`, `adults`, `children`, `created_at`, `status`, `registered_by` 
function getPouchiSetupData($conn) {
    $query = "SELECT `id`, `location_id`, `name`, `cost`, `description`, `adults`, `children`, `created_at`, `status`, `registered_by`  FROM `rooms`";
    $stmt = $conn->prepare($query);
    $stmt->execute();
    $result = $stmt->get_result();
    return $result;
}

// Fetch pouchi setup data
$pouchiSetups = getPouchiSetupData($conn);
$count = $pouchiSetups->num_rows;

if ($count > 0) {
    while ($row = $pouchiSetups->fetch_assoc()) {
        $id = htmlspecialchars($row['id']);
        $location_id = htmlspecialchars($row['location_id']);
        $name = htmlspecialchars($row['name']);
        $cost = htmlspecialchars($row['cost']);
        $description = htmlspecialchars($row['description']);
        $adults = htmlspecialchars($row['adults']);
        $children = htmlspecialchars($row['children']);
        $created_at = htmlspecialchars($row['created_at']);
        $status = htmlspecialchars($row['status']);
        $registered_by = $row['registered_by'];
    
$statusCSS = "";
$statusParam = "";
 
        if ($status == 1) {
            $statusParam = "Active";
            $statusCSS = "badge bg-grd-warning";
        } else if ($status == 2) {
            $statusParam = "Paid";
            $statusCSS = "badge bg-grd-success";
        } else if ($status == 3) {
            $statusParam = "Checked In";
            $statusCSS = "badge bg-grd-success";
        } else if ($status == 4) {
            $statusParam = "Over Stayed";
            $statusCSS = "badge bg-grd-danger";
        } else if ($status == 5) {
            $statusParam = "Checked Out";
            $statusCSS = "badge bg-grd-success";
        } else if ($status == 6) {
            $statusParam = "Payment Failed";
            $statusCSS = "badge bg-grd-danger";
        }
        
        $location_name = $myName->showName($conn, "SELECT `name` FROM `location` WHERE `id` = '$location_id'");	

        echo '<tr>
            <td><a href="view-room-details-full?value=' . $id . '"> <strong>' . $name . '</strong> </a></td>
            <td>' . $location_name . '</td>
            <td>&#8358; ' . number_format(floatval($cost), 2) . '</td>
            <td>  ' .$adults.'/'.$children . '</td>
           
             <td>' . $created_at . '</td>
            <td>' . $registered_by . '</td>
            <td> <span class="' . $statusCSS . '">' . $statusParam . ' </span> </td>
            <td>
                <div class="btn-group">
                    <button class="btn btn-warning text-black dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">Options</button>
                    <ul class="dropdown-menu dropdown-block">
                        <li><a class="dropdown-item" onclick="return confirm(\'Are you sure you want to delete?\')" href="?table=rooms&del=' . $id . '">Delete</a></li>
                        <li><a class="dropdown-item" onclick="return confirm(\'Are you sure you want to update?\')" href="?table=rooms&id=' . $id . '&columnValue=1&column=status">Activate</a></li>
                        <li><a class="dropdown-item" onclick="return confirm(\'Are you sure you want to update?\')" href="?table=rooms&id=' . $id . '&columnValue=0&column=status">Deactivate</a></li>
                    </ul>
                </div>
            </td>
        </tr>';
    }
} else {
    echo '<tr><td colspan="13">No records found.</td></tr>';
}

$conn->close();
?>
