<?php
include("app-config/DB_config.php");
$myName = new Name();

$emailing = isset($_SESSION['email']) ? $_SESSION['email'] : '';
//SELECT`id`, `name`, `position`, `testimony`, `picture_path`, `created_at`, `updated_at` FROM `testimony` WHERE 1
 
function getPouchiSetupData($conn) {
    $query = "SELECT `id`, `name`, `position`, `testimony`, `picture_path`, `created_at`, `updated_at` , `status` FROM `testimony`";
    $stmt = $conn->prepare($query);
    $stmt->execute();
    $result = $stmt->get_result();
    return $result;
}

// Fetch pouchi setup data
$pouchiSetups = getPouchiSetupData($conn);
$count = $pouchiSetups->num_rows;

if ($count > 0) {
    while ($row = $pouchiSetups->fetch_assoc()) {
        $id = htmlspecialchars($row['id']);
        $name = htmlspecialchars($row['name']);
        $position = htmlspecialchars($row['position']);
        $testimony = htmlspecialchars($row['testimony']);
        $picture_path = htmlspecialchars($row['picture_path']);
        $created_at = htmlspecialchars($row['created_at']);
        $updated_at = htmlspecialchars($row['updated_at']);
        $status = htmlspecialchars($row['status']);
       
       

        $statusCSS = $status == 1 ? "badge bg-grd-success" : "badge bg-grd-danger";
        $statusParam = $status == 1 ? "Active" : "Not Active";

        echo '<tr>
            <td><a href="view-testimonial?value=' . $id . '"> <strong>' . $name . '</strong> </a></td>
            <td><a href="view-testimonial?value=' . $id . '"> <strong>' . $position . '</strong> </a></td>
             <td>' . $created_at . '</td>
            <td> <span class="' . $statusCSS . '">' . $statusParam . ' </span> </td>
            <td>
                <div class="btn-group">
                    <button class="btn btn-warning text-black dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">Options</button>
                    <ul class="dropdown-menu dropdown-block">
                        <li><a class="dropdown-item" onclick="return confirm(\'Are you sure you want to delete?\')" href="?table=testimony&del=' . $id . '">Delete</a></li>
                        <li><a class="dropdown-item" onclick="return confirm(\'Are you sure you want to update?\')" href="?table=testimony&id=' . $id . '&columnValue=1&column=status">Activate</a></li>
                        <li><a class="dropdown-item" onclick="return confirm(\'Are you sure you want to update?\')" href="?table=testimony&id=' . $id . '&columnValue=0&column=status">Deactivate</a></li>
                    </ul>
                </div>
            </td>
        </tr>';
    }
} else {
    echo '<tr><td colspan="13">No records found.</td></tr>';
}

$conn->close();
?>
