<?php

function verifyNINPhone($accessToken, $phoneNumber, $firstname, $lastname) {
    // Initialize cURL
    $curl = curl_init();

    // Set cURL options
    curl_setopt_array($curl, [
        CURLOPT_URL => "https://api.qoreid.com/v1/ng/identities/nin-phone/" . urlencode($phoneNumber),
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_CUSTOMREQUEST => "POST",
        CURLOPT_HTTPHEADER => [
            "Accept: application/json",
            "Authorization: Bearer " . $accessToken,
            "Content-Type: application/json"
        ],
        CURLOPT_POSTFIELDS => json_encode([
            "firstname" => $firstname,
            "lastname" => $lastname
        ]),
    ]);

    // Execute the request and capture the response
    $response = curl_exec($curl);

    // Check for cURL errors
    if (curl_errno($curl)) {
        echo 'Error:' . curl_error($curl);
        curl_close($curl);
        return null; // Return null if there's an error
    }

    // Close cURL session
    curl_close($curl);

    // Decode the JSON response
    $data = json_decode($response, true);

    // Check if decoding was successful
    if (json_last_error() === JSON_ERROR_NONE) {
        return $data; // Return the decoded response
    } else {
        // Handle JSON decode error
        echo "Failed to decode JSON response: " . json_last_error_msg() . PHP_EOL;
        return null; // Return null if decoding fails
    }
}

// Example usage:
$accessToken = "eyJhbGciOiJSUzI1NiIsInR5cCIgOiAiSldUIiwia2lkIiA6ICIzaVgtaEFrS3RmNUlsYWhRcElrNWwwb";
$phoneNumber = "08000000000";
$firstname = "John";
$lastname = "Smith";

$response = verifyNINPhone($accessToken, $phoneNumber, $firstname, $lastname);

if ($response) {
    // Handle the response
    if ($response['status']['state'] === 'complete' && $response['status']['status'] === 'id_mismatch') {
        echo "NIN and phone number mismatch for applicant.\n";
        echo "NIN Provided: " . $response['nin']['nin'] . "\n";
        echo "Actual Firstname: " . $response['nin']['firstname'] . "\n";
        echo "Actual Lastname: " . $response['nin']['lastname'] . "\n";
        echo "Middle Name: " . $response['nin']['middlename'] . "\n";
        echo "Phone: " . $response['nin']['phone'] . "\n";
        echo "Gender: " . $response['nin']['gender'] . "\n";
        echo "Photo (Base64): " . $response['nin']['photo'] . "\n";
        echo "Birthdate: " . $response['nin']['birthdate'] . "\n";
        echo "Residence Address: " . $response['nin']['residence']['address1'] . "\n";
        echo "LGA: " . $response['nin']['residence']['lga'] . "\n";
        echo "State: " . $response['nin']['residence']['state'] . "\n";
    } else {
        echo "NIN and phone number matched.\n";
    }
} else {
    echo "Failed to verify NIN and phone number." . PHP_EOL;
}

?>
